/*
 * Decompiled with CFR 0.152.
 */
package sample;

public class RecombSingleNodes {
    private static final double loadFactor = 0.75;
    private final int nNodes;
    private int size = 0;
    private int capacity;
    private int rehashThreshold;
    private int[] index;
    private int[] node1;
    private int[] node2;
    private float[] value;
    private float[] sumNode1Value;
    private float[] sumNode2Value;
    private float sumValue;

    public RecombSingleNodes(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("nNodes < 1: " + n);
        }
        this.nNodes = n;
        this.size = 0;
        this.capacity = 1024;
        this.rehashThreshold = (int)(0.75 * (double)this.capacity);
        this.index = new int[this.capacity];
        this.node1 = new int[this.capacity];
        this.node2 = new int[this.capacity];
        this.value = new float[this.capacity];
        this.sumNode1Value = new float[n];
        this.sumNode2Value = new float[n];
        this.sumValue = 0.0f;
    }

    private static long hash1(int n, int n2) {
        long l = 5L;
        l = 71L * l + (long)n;
        l = 71L * l + (long)n2;
        return l;
    }

    private static long hash2(int n, int n2) {
        long l = 7L;
        l = 97L * l + (long)n;
        l = 97L * l + (long)n2;
        return l;
    }

    private int index(int n, int n2) {
        long l = RecombSingleNodes.hash1(n, n2);
        long l2 = RecombSingleNodes.hash2(n, n2);
        if ((l2 & 1L) == 0L) {
            ++l2;
        }
        long l3 = l;
        for (int i = 0; i < this.capacity; ++i) {
            int n3 = (int)(l3 % (long)this.capacity);
            if ((double)this.value[n3] == 0.0 || this.node1[n3] == n && this.node2[n3] == n2) {
                return n3;
            }
            l3 += l2;
        }
        assert (false);
        return -1;
    }

    private void rehash() {
        assert (this.size >= this.rehashThreshold);
        int n = 2 * this.capacity;
        if (n < 0) {
            throw new IllegalStateException("hash table overflow");
        }
        int[] nArray = this.index;
        int[] nArray2 = this.node1;
        int[] nArray3 = this.node2;
        float[] fArray = this.value;
        this.capacity = n;
        this.index = new int[n];
        this.node1 = new int[n];
        this.node2 = new int[n];
        this.value = new float[n];
        for (int i = 0; i < this.size; ++i) {
            int n2;
            int n3 = nArray[i];
            this.index[i] = n2 = this.index(nArray2[n3], nArray3[n3]);
            this.node1[n2] = nArray2[n3];
            this.node2[n2] = nArray3[n3];
            this.value[n2] = fArray[n3];
        }
        this.rehashThreshold = (int)(0.75 * (double)this.capacity);
    }

    public void sumUpdate(int n, int n2, float f) {
        if (f <= 0.0f || !Double.isFinite(f)) {
            throw new IllegalArgumentException(String.valueOf(f));
        }
        int n3 = this.index(n, n2);
        boolean bl = this.value[n3] == 0.0f;
        int n4 = n3;
        this.value[n4] = this.value[n4] + f;
        int n5 = n;
        this.sumNode1Value[n5] = this.sumNode1Value[n5] + f;
        int n6 = n2;
        this.sumNode2Value[n6] = this.sumNode2Value[n6] + f;
        this.sumValue += f;
        if (bl) {
            this.index[this.size++] = n3;
            this.node1[n3] = n;
            this.node2[n3] = n2;
            if (this.size >= this.rehashThreshold) {
                this.rehash();
            }
        }
    }

    public int size() {
        return this.size;
    }

    private void checkSize(int n) {
        if (n >= this.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
    }

    public int nNodes() {
        return this.nNodes;
    }

    public int enumNode1(int n) {
        this.checkSize(n);
        return this.node1[this.index[n]];
    }

    public int enumNode2(int n) {
        this.checkSize(n);
        return this.node2[this.index[n]];
    }

    public float enumValue(int n) {
        this.checkSize(n);
        return this.value[this.index[n]];
    }

    public float value(int n, int n2) {
        if (n < 0 || n >= this.nNodes) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        if (n2 < 0 || n2 >= this.nNodes) {
            throw new IndexOutOfBoundsException(String.valueOf(n2));
        }
        return this.value[this.index(n, n2)];
    }

    public float sumNode1Value(int n) {
        return this.sumNode1Value[n];
    }

    public float sumNode2Value(int n) {
        return this.sumNode2Value[n];
    }

    public float sumValue() {
        return this.sumValue;
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.value[this.index[i]] = 0.0f;
            this.sumNode1Value[this.node1[this.index[i]]] = 0.0f;
            this.sumNode2Value[this.node2[this.index[i]]] = 0.0f;
        }
        this.sumValue = 0.0f;
        this.size = 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("size=");
        stringBuilder.append(this.size);
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(" (");
            stringBuilder.append(i);
            stringBuilder.append(": node1=");
            stringBuilder.append(this.enumNode1(i));
            stringBuilder.append(" node2=");
            stringBuilder.append(this.enumNode2(i));
            stringBuilder.append(" value=");
            stringBuilder.append(this.enumValue(i));
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }
}

