## -----------------------------------------------------------------------------
library(ggskewboxplots)

## -----------------------------------------------------------------------------
library(ggplot2)
library(ggskewboxplots)

ggplot(mpg, aes(x = class, y = hwy)) +
  geom_skewboxplot(method = "walker")

## -----------------------------------------------------------------------------
ggplot(mpg, aes(x = class, y = hwy)) +
  geom_skewboxplot(method = "adil", k = 2)

## -----------------------------------------------------------------------------
library(gridExtra)

p1 <- ggplot(mpg, aes(x = class, y = hwy)) + geom_skewboxplot(method = "tukey") + ggtitle("Tukey")
p2 <- ggplot(mpg, aes(x = class, y = hwy)) + geom_skewboxplot(method = "kimber") + ggtitle("Kimber")
p3 <- ggplot(mpg, aes(x = class, y = hwy)) + geom_skewboxplot(method = "hubert") + ggtitle("Hubert")

gridExtra::grid.arrange(p1, p2, p3, ncol = 1)

