/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.parsers;

import dr.evolution.util.Taxon;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesBindings;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class AlloppSpeciesBindingsIndividualParser
extends AbstractXMLObjectParser {
    public static final String INDIVIDUAL = "individual";

    @Override
    public String getParserName() {
        return INDIVIDUAL;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        Taxon[] taxonArray = new Taxon[xMLObject.getChildCount()];
        for (int i = 0; i < taxonArray.length; ++i) {
            taxonArray[i] = (Taxon)xMLObject.getChild(i);
        }
        return new AlloppSpeciesBindings.Individual(xMLObject.getId(), taxonArray);
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return new XMLSyntaxRule[]{new ElementRule(Taxon.class, 1, Integer.MAX_VALUE)};
    }

    @Override
    public String getParserDescription() {
        return "Individual specimen from a species, possibly containing multiple genomes.";
    }

    @Override
    public Class getReturnType() {
        return AlloppSpeciesBindings.Individual.class;
    }
}

