/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.mcmcmc;

import dr.inference.markovchain.MarkovChain;
import dr.inference.mcmc.MCMCCriterion;
import dr.inference.mcmcmc.MCMCMCOptions;
import dr.inference.mcmcmc.ParallelTemperingStatistics;
import dr.inference.operators.AdaptableMCMCOperator;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.OperatorSchedule;
import dr.math.MathUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public interface ParallelTempering {
    public int swapChainTemperatures(int var1);

    public String getReport();

    public static enum HalfIndexSelector {
        ONE{

            @Override
            int[] indices(int n) {
                return new int[]{MathUtils.nextInt(n)};
            }
        }
        ,
        ALL{

            @Override
            int[] indices(int n) {
                if (all == null) {
                    HalfIndexSelector.access$202(new int[n]);
                    for (int i = 0; i < n; ++i) {
                        all[i] = i;
                    }
                }
                return all;
            }
        };

        private static int[] all;

        abstract int[] indices(int var1);

        static /* synthetic */ int[] access$202(int[] nArray) {
            all = nArray;
            return nArray;
        }

        static {
            all = null;
        }
    }

    public static enum ParitySelector {
        STOCHASTIC{

            @Override
            boolean next(boolean bl) {
                return MathUtils.nextBoolean();
            }
        }
        ,
        DETERMINISTIC{

            @Override
            boolean next(boolean bl) {
                return !bl;
            }
        };


        abstract boolean next(boolean var1);
    }

    public static class StochasticMultipleSwap
    extends New {
        public StochasticMultipleSwap(MarkovChain[] markovChainArray, OperatorSchedule[] operatorScheduleArray, MCMCMCOptions mCMCMCOptions) {
            super(markovChainArray, operatorScheduleArray, mCMCMCOptions, ParitySelector.STOCHASTIC, HalfIndexSelector.ALL);
        }
    }

    public static class StochasticSingleSwap
    extends New {
        public StochasticSingleSwap(MarkovChain[] markovChainArray, OperatorSchedule[] operatorScheduleArray, MCMCMCOptions mCMCMCOptions) {
            super(markovChainArray, operatorScheduleArray, mCMCMCOptions, ParitySelector.STOCHASTIC, HalfIndexSelector.ONE);
        }
    }

    public static class DeterministicMultipleSwap
    extends New {
        public DeterministicMultipleSwap(MarkovChain[] markovChainArray, OperatorSchedule[] operatorScheduleArray, MCMCMCOptions mCMCMCOptions) {
            super(markovChainArray, operatorScheduleArray, mCMCMCOptions, ParitySelector.DETERMINISTIC, HalfIndexSelector.ALL);
        }
    }

    public static class DeterministicSingleSwap
    extends New {
        public DeterministicSingleSwap(MarkovChain[] markovChainArray, OperatorSchedule[] operatorScheduleArray, MCMCMCOptions mCMCMCOptions) {
            super(markovChainArray, operatorScheduleArray, mCMCMCOptions, ParitySelector.DETERMINISTIC, HalfIndexSelector.ONE);
        }
    }

    public static abstract class New
    extends Base {
        private final ParitySelector paritySelector;
        private final HalfIndexSelector indexSelector;
        private final int K;
        private final int halfK;
        private boolean evenStep;
        private final int[] mapRankToChain;

        public New(MarkovChain[] markovChainArray, OperatorSchedule[] operatorScheduleArray, MCMCMCOptions mCMCMCOptions, ParitySelector paritySelector, HalfIndexSelector halfIndexSelector) {
            super(markovChainArray, operatorScheduleArray, mCMCMCOptions);
            int n;
            this.paritySelector = paritySelector;
            this.indexSelector = halfIndexSelector;
            this.K = n = mCMCMCOptions.getChainTemperatures().length;
            this.halfK = n / 2;
            this.mapRankToChain = new int[this.K];
            this.evenStep = MathUtils.nextBoolean();
        }

        private static boolean isOdd(int n) {
            return (n & 1) == 1;
        }

        @Override
        List<IndexPair> getPairsToSwap() {
            Serializable serializable;
            int n = 0;
            while (n < this.K) {
                serializable = (MCMCCriterion)this.chains[n].getAcceptor();
                int n2 = ((MCMCCriterion)serializable).getRank();
                this.mapRankToChain[n2] = n++;
            }
            this.evenStep = this.paritySelector.next(this.evenStep);
            int[] nArray = this.indexSelector.indices(this.halfK);
            serializable = new ArrayList();
            for (int n3 : nArray) {
                int n4 = 2 * n3 + (this.evenStep ? 0 : 1);
                int n5 = n4 + 1;
                if (n5 >= this.K) {
                    n5 = 0;
                }
                serializable.add(new IndexPair(this.mapRankToChain[n4], this.mapRankToChain[n5]));
            }
            return serializable;
        }
    }

    public static class OriginalFlavor
    extends Base {
        public OriginalFlavor(MarkovChain[] markovChainArray, OperatorSchedule[] operatorScheduleArray, MCMCMCOptions mCMCMCOptions) {
            super(markovChainArray, operatorScheduleArray, mCMCMCOptions);
        }

        @Override
        List<IndexPair> getPairsToSwap() {
            int n = MathUtils.nextInt(this.chains.length);
            int n2 = MathUtils.nextInt(this.chains.length);
            while (n == n2) {
                n2 = MathUtils.nextInt(this.chains.length);
            }
            return Collections.singletonList(new IndexPair(n, n2));
        }
    }

    public static abstract class Base
    implements ParallelTempering {
        final MarkovChain[] chains;
        final OperatorSchedule[] schedules;
        final ParallelTemperingStatistics statistics;

        Base(MarkovChain[] markovChainArray, OperatorSchedule[] operatorScheduleArray, MCMCMCOptions mCMCMCOptions) {
            this.chains = markovChainArray;
            this.schedules = operatorScheduleArray;
            this.statistics = new ParallelTemperingStatistics(mCMCMCOptions);
        }

        abstract List<IndexPair> getPairsToSwap();

        @Override
        public int swapChainTemperatures(int n) {
            List<IndexPair> list = this.getPairsToSwap();
            for (IndexPair indexPair : list) {
                boolean bl = this.scoreSwap(indexPair);
                if (!bl) continue;
                this.swapTemperatures(indexPair);
                this.swapOperatorSchedules(indexPair);
                n = this.getNewColdChain(indexPair, n);
            }
            return n;
        }

        @Override
        public String getReport() {
            return this.statistics.getReport();
        }

        private int getNewColdChain(IndexPair indexPair, int n) {
            if (indexPair.index1 == n) {
                n = indexPair.index2;
            } else if (indexPair.index2 == n) {
                n = indexPair.index1;
            }
            return n;
        }

        private boolean scoreSwap(IndexPair indexPair) {
            double d = this.chains[indexPair.index1].getCurrentScore();
            MCMCCriterion mCMCCriterion = (MCMCCriterion)this.chains[indexPair.index1].getAcceptor();
            double d2 = mCMCCriterion.getTemperature();
            int n = mCMCCriterion.getRank();
            double d3 = this.chains[indexPair.index2].getCurrentScore();
            MCMCCriterion mCMCCriterion2 = (MCMCCriterion)this.chains[indexPair.index2].getAcceptor();
            double d4 = mCMCCriterion2.getTemperature();
            int n2 = mCMCCriterion2.getRank();
            double d5 = (d3 - d) * d2 + (d - d3) * d4;
            boolean bl = Math.log(MathUtils.nextDouble()) < d5;
            this.statistics.recordStatistics(indexPair.index1, indexPair.index2, n, n2, d2, d4, d5, bl);
            return bl;
        }

        private void swapTemperatures(IndexPair indexPair) {
            MCMCCriterion mCMCCriterion = (MCMCCriterion)this.chains[indexPair.index1].getAcceptor();
            double d = mCMCCriterion.getTemperature();
            MCMCCriterion mCMCCriterion2 = (MCMCCriterion)this.chains[indexPair.index2].getAcceptor();
            double d2 = mCMCCriterion2.getTemperature();
            mCMCCriterion.setTemperature(d2);
            mCMCCriterion2.setTemperature(d);
            int n = mCMCCriterion.getRank();
            int n2 = mCMCCriterion2.getRank();
            mCMCCriterion.setRank(n2);
            mCMCCriterion2.setRank(n);
        }

        private void swapOperatorSchedules(IndexPair indexPair) {
            OperatorSchedule operatorSchedule = this.schedules[indexPair.index1];
            OperatorSchedule operatorSchedule2 = this.schedules[indexPair.index2];
            for (int i = 0; i < operatorSchedule.getOperatorCount(); ++i) {
                MCMCOperator mCMCOperator = operatorSchedule.getOperator(i);
                MCMCOperator mCMCOperator2 = operatorSchedule2.getOperator(i);
                long l = mCMCOperator.getAcceptCount();
                mCMCOperator.setAcceptCount(mCMCOperator2.getAcceptCount());
                mCMCOperator2.setAcceptCount(l);
                l = mCMCOperator.getRejectCount();
                mCMCOperator.setRejectCount(mCMCOperator2.getRejectCount());
                mCMCOperator2.setRejectCount(l);
                double d = mCMCOperator.getSumDeviation();
                mCMCOperator.setSumDeviation(mCMCOperator2.getSumDeviation());
                mCMCOperator2.setSumDeviation(d);
                if (!(mCMCOperator instanceof AdaptableMCMCOperator)) continue;
                d = ((AdaptableMCMCOperator)mCMCOperator).getAdaptableParameter();
                ((AdaptableMCMCOperator)mCMCOperator).setAdaptableParameter(((AdaptableMCMCOperator)mCMCOperator2).getAdaptableParameter());
                ((AdaptableMCMCOperator)mCMCOperator2).setAdaptableParameter(d);
            }
        }
    }

    public static class IndexPair {
        int index1;
        int index2;

        IndexPair(int n, int n2) {
            this.index1 = n;
            this.index2 = n2;
        }
    }
}

