/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.treemetrics;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.treemetrics.RootedTreeMetric;
import jebl.evolution.trees.RootedTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CladeHeightMetric
implements RootedTreeMetric {
    BitSet tmpBits = new BitSet();
    private final Map<Taxon, Integer> taxonMap;

    public CladeHeightMetric() {
        this.taxonMap = null;
    }

    public CladeHeightMetric(List<Taxon> taxa) {
        this.taxonMap = new HashMap<Taxon, Integer>();
        for (int i = 0; i < taxa.size(); ++i) {
            this.taxonMap.put(taxa.get(i), i);
        }
    }

    @Override
    public double getMetric(RootedTree tree1, RootedTree tree2) {
        if (!((Object)tree1.getTaxa()).equals(tree2.getTaxa())) {
            throw new IllegalArgumentException("Trees contain different taxa");
        }
        Map<Taxon, Integer> tm = this.taxonMap;
        if (tm == null) {
            ArrayList<Taxon> taxa = new ArrayList<Taxon>(tree1.getTaxa());
            if (!((Object)tree2.getTaxa()).equals(taxa)) {
                tm = new HashMap<Taxon, Integer>();
            }
            for (int i = 0; i < taxa.size(); ++i) {
                tm.put((Taxon)taxa.get(i), i);
            }
        }
        ArrayList<Clade> clades1 = new ArrayList<Clade>();
        this.getClades(tm, tree1, tree1.getRootNode(), clades1, null);
        Collections.sort(clades1);
        ArrayList<Clade> clades2 = new ArrayList<Clade>();
        this.getClades(tm, tree2, tree2.getRootNode(), clades2, null);
        Collections.sort(clades2);
        return this.getDistance(clades1, clades2);
    }

    private void getClades(Map<Taxon, Integer> taxonMap, RootedTree tree, Node node, List<Clade> clades, BitSet bits) {
        BitSet bits2 = new BitSet();
        if (tree.isExternal(node)) {
            int index = taxonMap.get(tree.getTaxon(node));
            bits2.set(index);
        } else {
            for (Node child : tree.getChildren(node)) {
                this.getClades(taxonMap, tree, child, clades, bits2);
            }
            clades.add(new Clade(bits2, tree.getHeight(node)));
        }
        if (bits != null) {
            bits.or(bits2);
        }
    }

    private double getDistance(List<Clade> clades1, List<Clade> clades2) {
        double distance = 0.0;
        for (Clade clade1 : clades1) {
            double height1 = clade1.getHeight();
            Clade clade2 = this.findMRCA(clade1, clades2);
            double height2 = clade2.getHeight();
            distance += (height1 - height2) * (height1 - height2);
        }
        for (Clade clade2 : clades2) {
            double height2 = clade2.getHeight();
            Clade clade1 = this.findMRCA(clade2, clades1);
            double height1 = clade1.getHeight();
            distance += (height1 - height2) * (height1 - height2);
        }
        return Math.sqrt(distance);
    }

    private Clade findMRCA(Clade clade1, List<Clade> clades) {
        for (Clade clade2 : clades) {
            if (!this.isMRCA(clade1, clade2)) continue;
            return clade2;
        }
        return null;
    }

    private boolean isMRCA(Clade clade1, Clade clade2) {
        if (clade1.getSize() > clade2.getSize()) {
            return false;
        }
        this.tmpBits.clear();
        this.tmpBits.or(clade1.getBits());
        this.tmpBits.and(clade2.getBits());
        return this.tmpBits.cardinality() == clade1.getSize();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Clade
    implements Comparable<Clade> {
        private final BitSet bits;
        private final double height;
        private final int size;

        public Clade(BitSet bits, double height) {
            this.bits = bits;
            this.height = height;
            this.size = bits.cardinality();
        }

        public BitSet getBits() {
            return this.bits;
        }

        public double getHeight() {
            return this.height;
        }

        public int getSize() {
            return this.size;
        }

        @Override
        public int compareTo(Clade clade) {
            int j;
            int i = this.bits.cardinality();
            return i < (j = clade.bits.cardinality()) ? -1 : (i > j ? 1 : 0);
        }
    }
}

