/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo;

import cern.colt.Partitioning;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;

public class FloatPartitioning {
    protected FloatPartitioning() {
    }

    public static void partition(FloatMatrix2D floatMatrix2D, int[] nArray, int n, int n2, int n3, final float[] fArray, int n4, int n5, int[] nArray2) {
        if (n < 0 || n2 >= floatMatrix2D.rows() || n2 >= nArray.length) {
            throw new IllegalArgumentException();
        }
        if (n3 < 0 || n3 >= floatMatrix2D.columns()) {
            throw new IllegalArgumentException();
        }
        if (n4 < 0 || n5 >= fArray.length) {
            throw new IllegalArgumentException();
        }
        if (nArray2.length < fArray.length) {
            throw new IllegalArgumentException();
        }
        final int[] nArray3 = nArray;
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                int n3 = nArray3[n];
                nArray3[n] = nArray3[n2];
                nArray3[n2] = n3;
            }
        };
        final FloatMatrix1D floatMatrix1D = floatMatrix2D.viewColumn(n3);
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                float f = fArray[n];
                float f2 = floatMatrix1D.getQuick(nArray3[n2]);
                return f < f2 ? -1 : (f == f2 ? 0 : 1);
            }
        };
        IntComparator intComparator2 = new IntComparator(){

            public int compare(int n, int n2) {
                float f;
                float f2 = floatMatrix1D.getQuick(nArray3[n]);
                return f2 < (f = floatMatrix1D.getQuick(nArray3[n2])) ? -1 : (f2 == f ? 0 : 1);
            }
        };
        IntComparator intComparator3 = new IntComparator(){

            public int compare(int n, int n2) {
                float f = fArray[n];
                float f2 = fArray[n2];
                return f < f2 ? -1 : (f == f2 ? 0 : 1);
            }
        };
        Partitioning.genericPartition(n, n2, n4, n5, nArray2, intComparator, intComparator2, intComparator3, swapper);
    }

    public static FloatMatrix2D partition(FloatMatrix2D floatMatrix2D, int n, float[] fArray, int[] nArray) {
        int n2 = 0;
        int n3 = floatMatrix2D.rows() - 1;
        int n4 = 0;
        int n5 = fArray.length - 1;
        int[] nArray2 = new int[floatMatrix2D.rows()];
        int n6 = nArray2.length;
        while (--n6 >= 0) {
            nArray2[n6] = n6;
        }
        FloatPartitioning.partition(floatMatrix2D, nArray2, n2, n3, n, fArray, n4, n5, nArray);
        int[] nArray3 = new int[floatMatrix2D.columns()];
        int n7 = nArray3.length;
        while (--n7 >= 0) {
            nArray3[n7] = n7;
        }
        return floatMatrix2D.viewSelection(nArray2, nArray3);
    }
}

