/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.algorithm;

import ec.tstoolkit.algorithm.BatchProcessing;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.algorithm.ProcessingManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BatchProcessingFactory {
    private ArrayList<Node<? extends IProcSpecification>> nodes_ = new ArrayList();

    public <S extends IProcSpecification, D> void add(Node<S> node) {
        this.nodes_.add(node);
    }

    public List<Node<? extends IProcSpecification>> nodes() {
        return Collections.unmodifiableList(this.nodes_);
    }

    public BatchProcessing createProcessing(ProcessingContext context) {
        BatchProcessing proc = new BatchProcessing();
        for (Node<? extends IProcSpecification> node : this.nodes_) {
            BatchProcessing.ILink<Object> link;
            switch (node.linkType.ordinal()) {
                case 0: {
                    link = new BatchProcessing.InputLink<Object>(node.linkId, Object.class);
                    break;
                }
                case 1: {
                    link = new BatchProcessing.OutputLink<Object>(node.linkId, Object.class);
                    break;
                }
                default: {
                    link = new BatchProcessing.Link<Object>(node.linkId, Object.class);
                }
            }
            IProcessing<?, ?> processing = ProcessingManager.getInstance().createProcessor(node.specification, context);
            proc.add(new BatchProcessing.Node(node.name, link, processing));
        }
        return proc;
    }

    public static class Node<S extends IProcSpecification> {
        public final String name;
        public final S specification;
        public final LinkType linkType;
        public final String linkId;

        public Node(String name, S specification, LinkType linkType, String linkId) {
            this.name = name;
            this.specification = specification;
            this.linkType = linkType;
            this.linkId = linkId;
        }
    }

    public static enum LinkType {
        Input,
        Output,
        Result;

    }
}

