---
title: public.ctn0094data
---

<!-- badges: start -->
[![R-CMD-check](https://github.com/CTN-0094/public.ctn0094data/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/CTN-0094/public.ctn0094data/actions/workflows/R-CMD-check.yaml)
<!-- badges: end -->

# Introduction to public.ctn0094data: De-Identified Data from the CTN-0094 Protocol

These are harmonized/normalized data sets produced as part of the Clinical Trials Network (CTN) protocol number 0094. The data describe the experiences of care seeking individuals suffering from opioid use disorder (OUD). This is a US National Institute of Drug Abuse (NIDA) funded project; to learn more go to <https://ctnlibrary.org/protocol/ctn0094/>. The datasets which have data harmonized are from:

- CTN-0027 (<https://ctnlibrary.org/protocol/ctn0027/>),
- CTN-0030 (<https://ctnlibrary.org/protocol/ctn0030/>), and
- CTN-0051 (<https://ctnlibrary.org/protocol/ctn0051/>).

For lists of data tables and summaries of their contents, please see the "Harmonization Information" vignette.



## Installation

We are currently submitting this package to CRAN. After it is accepted, you will be able to install the released version of public.ctn0094data from [CRAN](https://CRAN.R-project.org) with:

``` r
# Do not run yet
# install.packages("public.ctn0094data")
```

For now, you can use the [remotes](https://CRAN.R-project.org/package=remotes) package to install this database directly from GitHub with:
```r
remotes::install_github("CTN-0094/public.ctn0094data")
```

## Citing this Package
We expect the paper corresponding to this package will be published shortly in PLOS One. The expected citation would be

> Balise RR, Hu MC, Odom GJ, Calderon A, Luo SX, Feaster DJ, and the CTN-0094 Team. (*In submission*, expected 2024). "The Harmonization of 'High Stakes' Clinical Trial Data: Medication Assisted Treatment for Opioid Use Disorder." *PLOS One*.

To find citation information for this package, call the following code:
```r
citation("public.ctn0094data")
```

