/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r.Fares;

import com.conveyal.r5.analyst.fare.FareBounds;
import com.conveyal.r5.analyst.fare.InRoutingFareCalculator;
import com.conveyal.r5.analyst.fare.TransferAllowance;
import com.conveyal.r5.profile.McRaptorSuboptimalPathProfileRouter;
import com.conveyal.r5.transit.RouteInfo;
import com.conveyal.r5.transit.TransitLayer;
import com.conveyal.r5.transit.TripPattern;
import gnu.trove.list.array.TIntArrayList;
import java.util.HashMap;
import org.ipea.r5r.Fares.FarePerRoute;
import org.ipea.r5r.Fares.FarePerTransfer;
import org.ipea.r5r.Fares.FarePerType;
import org.ipea.r5r.Fares.FareStructure;
import org.ipea.r5r.Fares.IntegratedFare;
import org.ipea.r5r.Fares.R5RTransferAllowance;
import org.ipea.r5r.Process.ParetoItineraryPlanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBasedInRoutingFareCalculator
extends InRoutingFareCalculator {
    private static final Logger LOG = LoggerFactory.getLogger(RuleBasedInRoutingFareCalculator.class);
    private final FareStructure fareStructure;
    private FarePerRoute[] faresPerRoute;
    private FarePerTransfer[][] faresPerTransfer;

    public FareStructure getFareStructure() {
        return this.fareStructure;
    }

    public RuleBasedInRoutingFareCalculator(TransitLayer transitLayer, String jsonData) {
        this.transitLayer = transitLayer;
        this.fareStructure = FareStructure.fromJson(jsonData);
        this.loadFareInformation();
    }

    private void loadFareInformation() {
        int i;
        HashMap<String, FarePerRoute> indexRouteInfo = new HashMap<String, FarePerRoute>();
        for (FarePerRoute route : this.fareStructure.getFaresPerRoute()) {
            indexRouteInfo.put(route.getUniqueId(), route);
        }
        HashMap<String, Integer> indexTransportType = new HashMap<String, Integer>();
        for (i = 0; i < this.fareStructure.getFaresPerType().size(); ++i) {
            indexTransportType.put(this.fareStructure.getFaresPerType().get(i).getType(), i);
        }
        this.faresPerRoute = new FarePerRoute[this.transitLayer.tripPatterns.size()];
        for (i = 0; i < this.transitLayer.tripPatterns.size(); ++i) {
            RouteInfo ri = (RouteInfo)this.transitLayer.routes.get(((TripPattern)this.transitLayer.tripPatterns.get((int)i)).routeIndex);
            this.faresPerRoute[i] = (FarePerRoute)indexRouteInfo.get(FarePerRoute.getUniqueId(ri));
            int typeIndex = (Integer)indexTransportType.get(this.faresPerRoute[i].getFareType());
            this.faresPerRoute[i].setTypeIndex(typeIndex);
            FarePerType typeOfRoute = this.fareStructure.getFaresPerType().get(typeIndex);
            if (typeOfRoute.isUseRouteFare()) continue;
            this.faresPerRoute[i].setRouteFare(typeOfRoute.getFare());
        }
        int nTypes = this.fareStructure.getFaresPerType().size();
        this.faresPerTransfer = new FarePerTransfer[nTypes][nTypes];
        for (FarePerTransfer transfer : this.fareStructure.getFaresPerTransfer()) {
            int firstTypeIndex = (Integer)indexTransportType.get(transfer.getFirstLeg());
            int secondTypeIndex = (Integer)indexTransportType.get(transfer.getSecondLeg());
            transfer.setFirstLegFullIntegerFare(this.fareStructure.getFaresPerType().get(firstTypeIndex).getIntegerFare());
            transfer.setSecondLegFullIntegerFare(this.fareStructure.getFaresPerType().get(secondTypeIndex).getIntegerFare());
            this.faresPerTransfer[firstTypeIndex][secondTypeIndex] = transfer;
        }
    }

    private FarePerType getTypeByIndex(int index) {
        return this.fareStructure.getFaresPerType().get(index);
    }

    private FarePerTransfer getTransferByIndex(int firstTypeIndex, int secondTypeIndex) {
        return this.faresPerTransfer[firstTypeIndex][secondTypeIndex];
    }

    public FareBounds calculateFare(McRaptorSuboptimalPathProfileRouter.McRaptorState state, int maxClockTime) {
        TIntArrayList patterns = new TIntArrayList();
        TIntArrayList boardTimes = new TIntArrayList();
        while (state != null) {
            if (state.pattern > -1) {
                patterns.add(state.pattern);
                boardTimes.add(state.boardTime);
            }
            state = state.back;
        }
        patterns.reverse();
        boardTimes.reverse();
        int fareForState = 0;
        int previousPatternIndex = -1;
        int discountsApplied = 0;
        int previousBoardTime = 0;
        int currentPatternIndex = -1;
        int currentBoardTime = -1;
        int lastFareType = -1;
        if (!patterns.isEmpty()) {
            currentPatternIndex = patterns.get(0);
            previousBoardTime = boardTimes.get(0);
            fareForState = this.getFullFareForRoute(currentPatternIndex);
            previousPatternIndex = currentPatternIndex;
            lastFareType = this.faresPerRoute[currentPatternIndex].getTypeIndex();
        }
        for (int ride = 1; ride < patterns.size(); ++ride) {
            FarePerType farePerType;
            currentPatternIndex = patterns.get(ride);
            currentBoardTime = boardTimes.get(ride);
            FarePerRoute firstLegType = this.faresPerRoute[previousPatternIndex];
            FarePerRoute secondLegType = this.faresPerRoute[currentPatternIndex];
            lastFareType = secondLegType.getTypeIndex();
            if (firstLegType.getTypeIndex() == secondLegType.getTypeIndex() && (farePerType = this.getTypeByIndex(firstLegType.getTypeIndex())).isUnlimitedTransfers()) {
                previousPatternIndex = currentPatternIndex;
                continue;
            }
            if (discountsApplied >= this.fareStructure.getMaxDiscountedTransfers()) {
                fareForState += this.getFullFareForRoute(currentPatternIndex);
            } else {
                IntegratedFare integratedFare = this.getIntegrationFare(previousPatternIndex, currentPatternIndex, currentBoardTime - previousBoardTime);
                fareForState += integratedFare.fare;
                if (integratedFare.usedDiscount) {
                    ++discountsApplied;
                }
            }
            previousPatternIndex = currentPatternIndex;
            previousBoardTime = currentBoardTime;
        }
        if (this.fareStructure.getFareCap() > 0.0f) {
            fareForState = Math.min(fareForState, this.fareStructure.getIntegerFareCap());
        }
        if (!ParetoItineraryPlanner.travelAllowanceActive) {
            return new FareBounds(fareForState, (TransferAllowance)new R5RTransferAllowance());
        }
        if (currentPatternIndex == -1) {
            return new FareBounds(fareForState, (TransferAllowance)new R5RTransferAllowance());
        }
        int numberOfRemainingTransfers = this.fareStructure.getMaxDiscountedTransfers() - discountsApplied;
        if (numberOfRemainingTransfers <= 0) {
            return new FareBounds(fareForState, (TransferAllowance)new R5RTransferAllowance());
        }
        int fullFare = this.getFullFareForRoute(currentPatternIndex);
        int maxAllowanceValue = 0;
        for (FarePerTransfer transfer : this.faresPerTransfer[this.faresPerRoute[currentPatternIndex].getTypeIndex()]) {
            if (transfer == null) continue;
            int fullTransferFare = transfer.getFirstLegFullIntegerFare() + transfer.getSecondLegFullIntegerFare();
            int allowance = fullTransferFare - transfer.getIntegerFare();
            maxAllowanceValue = Math.max(allowance, maxAllowanceValue);
        }
        if (this.fareStructure.getFareCap() > 0.0f && fareForState > this.fareStructure.getIntegerFareCap()) {
            maxAllowanceValue = Math.max(fullFare, maxAllowanceValue);
        }
        int n = currentBoardTime + this.fareStructure.getTransferTimeAllowanceSeconds();
        R5RTransferAllowance transferAllowance = new R5RTransferAllowance(lastFareType, maxAllowanceValue, numberOfRemainingTransfers, n);
        return new FareBounds(fareForState, (TransferAllowance)transferAllowance);
    }

    private int getFullFareForRoute(int patternIndex) {
        FarePerRoute routeInfoData = this.faresPerRoute[patternIndex];
        return routeInfoData.getIntegerFare();
    }

    private IntegratedFare getIntegrationFare(int firstPattern, int secondPattern, int transferTime) {
        FarePerRoute firstLeg = this.faresPerRoute[firstPattern];
        FarePerRoute secondLeg = this.faresPerRoute[secondPattern];
        FarePerTransfer transferFare = this.getTransferByIndex(firstLeg.getTypeIndex(), secondLeg.getTypeIndex());
        if (transferFare == null) {
            int fareSecondLeg = this.getFullFareForRoute(secondPattern);
            return new IntegratedFare(fareSecondLeg, false);
        }
        if (!this.isTransferAllowed(firstLeg, secondLeg)) {
            int fareSecondLeg = this.getFullFareForRoute(secondPattern);
            return new IntegratedFare(fareSecondLeg, false);
        }
        if (transferTime > this.fareStructure.getTransferTimeAllowanceSeconds()) {
            int fareSecondLeg = this.getFullFareForRoute(secondPattern);
            return new IntegratedFare(fareSecondLeg, false);
        }
        int fareFirstLeg = this.getFullFareForRoute(firstPattern);
        return new IntegratedFare(transferFare.getIntegerFare() - fareFirstLeg, true);
    }

    private boolean isTransferAllowed(FarePerRoute firstLeg, FarePerRoute secondLeg) {
        if (firstLeg.getTypeIndex() == secondLeg.getTypeIndex()) {
            FarePerType typeData = this.getTypeByIndex(firstLeg.getTypeIndex());
            if (typeData.isAllowSameRouteTransfer()) {
                return true;
            }
            return !firstLeg.getRouteId().equals(secondLeg.getRouteId());
        }
        return true;
    }

    public String getType() {
        return "rule-based";
    }
}

