/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.base;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.validation.ValidatorHandler;
import nu.xom.Document;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.converters.SAXConverter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class CMLSchemaValidator {
    private static final String SCHEMA_FILE = "schema.xsd";
    private static CMLSchemaValidator instance;
    private Schema schema;

    public static CMLSchemaValidator getInstance() throws IOException {
        if (instance == null) {
            CMLSchemaValidator.createInstance();
        }
        return instance;
    }

    private static synchronized void createInstance() throws IOException {
        if (instance == null) {
            instance = new CMLSchemaValidator();
        }
    }

    private CMLSchemaValidator() throws IOException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream is = this.getClass().getResourceAsStream(SCHEMA_FILE);
        if (is == null) {
            throw new IOException("Cannot find schema file: schema.xsd");
        }
        try {
            StreamSource schemaFile = new StreamSource(is);
            this.schema = factory.newSchema(schemaFile);
        }
        catch (SAXException e) {
            throw new RuntimeException("invalid schema", e);
        }
        finally {
            is.close();
        }
    }

    public void validateCML(Source source) throws IOException {
        Validator validator = this.schema.newValidator();
        try {
            validator.validate(source);
        }
        catch (SAXException e) {
            throw new RuntimeException("not valid CML", e);
        }
    }

    public void validateCML(InputStream in) throws IOException {
        this.validateCML(new StreamSource(in));
    }

    public void validateCML(Reader in) throws IOException {
        this.validateCML(new StreamSource(in));
    }

    public void validateCML(Document d) throws IOException {
        ValidatorHandler handler = this.schema.newValidatorHandler();
        SAXConverter converter = new SAXConverter((ContentHandler)handler);
        try {
            converter.convert(d);
        }
        catch (SAXException e) {
            throw new RuntimeException("not valid CML", e);
        }
    }

    public void validateCML(Node node) throws IOException {
        ValidatorHandler handler = this.schema.newValidatorHandler();
        SAXConverter converter = new SAXConverter((ContentHandler)handler);
        try {
            converter.convert(new Nodes(node));
        }
        catch (SAXException e) {
            throw new RuntimeException("not valid CML", e);
        }
    }

    public void validateCML(org.w3c.dom.Node node) throws IOException {
        DOMSource source = new DOMSource(node);
        this.validateCML(source);
    }
}

