/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.splines;

import jdplus.toolkit.base.api.DemetraException;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.data.DataBlockIterator;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import lombok.Generated;

public final class BSplines {
    public static BSpline augmented(int order, double[] breaks) {
        return BSpline.of(order, breaks);
    }

    public static BSpline periodic(int order, double[] breaks, double period) {
        return BSpline.ofPeriodic(order, breaks, period);
    }

    public static FastMatrix splines(BSpline spline, DoubleSeq pos) {
        int dim = spline.dimension();
        FastMatrix M = FastMatrix.make(pos.length(), dim);
        DoubleSeqCursor cursor = pos.cursor();
        double[] B = new double[spline.getOrder()];
        DataBlockIterator rows = M.rowsIterator();
        while (rows.hasNext()) {
            int left = spline.eval(cursor.getAndNext(), B);
            if (left < 0) {
                left += dim;
            }
            DataBlock row = rows.next();
            for (int i = 0; i < B.length; ++i) {
                row.set((i + left) % dim, B[i]);
            }
        }
        return M;
    }

    @Generated
    private BSplines() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class BSpline {
        private final int k;
        private final int n;
        private final double[] knots;
        private final double period;
        private final double[] deltar;
        private final double[] deltal;

        private BSpline(int k, int n, double[] knots, double period) {
            this.k = k;
            this.n = n;
            this.knots = knots;
            this.deltal = new double[k];
            this.deltar = new double[k];
            this.period = period;
        }

        public boolean isPeriodic() {
            return this.period != 0.0;
        }

        public double getPeriod() {
            return this.period;
        }

        public int getOrder() {
            return this.k;
        }

        public DoubleSeq knots() {
            return DoubleSeq.of((double[])this.knots, (int)(this.k - 1), (int)this.n);
        }

        public int dimension() {
            return this.n;
        }

        public int eval(double x, double[] B) {
            int end;
            if (x < this.knots[this.k - 1]) {
                if (!this.isPeriodic()) {
                    return -1;
                }
                x += this.period;
            }
            int n = end = this.isPeriodic() ? this.pfindInterval(x) : this.findInterval(x);
            if (end < this.k - 1) {
                return -1;
            }
            this.pppack_bsplvb(x, end, B);
            return end - this.k + 1;
        }

        void pppack_bsplvb(double x, int left, double[] biatx) {
            biatx[0] = 1.0;
            for (int j = 0; j < this.k - 1; ++j) {
                this.deltar[j] = this.knots[left + j + 1] - x;
                this.deltal[j] = x - this.knots[left - j];
                double saved = 0.0;
                for (int i = 0; i <= j; ++i) {
                    double term = biatx[i] / (this.deltar[i] + this.deltal[j - i]);
                    biatx[i] = saved + this.deltar[i] * term;
                    saved = this.deltal[j - i] * term;
                }
                biatx[j + 1] = saved;
            }
        }

        private int pfindInterval(double x) {
            int imax = this.k + this.n - 1;
            for (int i = this.k - 1; i < imax; ++i) {
                double ti = this.knots[i];
                double tip1 = this.knots[i + 1];
                if (!(ti <= x) || !(x < tip1)) continue;
                return i;
            }
            return imax;
        }

        private int findInterval(double x) {
            int imax = this.k + this.n - 1;
            for (int i = this.k - 1; i < imax; ++i) {
                double ti = this.knots[i];
                double tip1 = this.knots[i + 1];
                if (ti <= x && x < tip1) {
                    return i;
                }
                if (!(ti < x) || x != tip1 || tip1 != this.knots[this.k + this.n - 2]) continue;
                return i;
            }
            return imax;
        }

        static BSpline of(int order, double[] breaks) {
            int i;
            BSpline.checkBreaks(breaks, 0.0);
            int k = order;
            int km1 = k - 1;
            int l = breaks.length;
            int n = breaks.length + km1;
            double[] knots = new double[n + km1];
            for (i = 0; i < km1; ++i) {
                knots[i] = breaks[0];
            }
            i = 0;
            int j = km1;
            while (i < breaks.length) {
                knots[j] = breaks[i];
                ++i;
                ++j;
            }
            for (i = n; i < knots.length; ++i) {
                knots[i] = breaks[l - 1];
            }
            return new BSpline(k, l, knots, 0.0);
        }

        static BSpline ofPeriodic(int order, double[] breaks, double P) {
            BSpline.checkBreaks(breaks, P);
            int k = order;
            int km1 = k - 1;
            int n = breaks.length;
            double[] knots = new double[n + 2 * km1 + 1];
            int i = 0;
            int j = km1;
            while (i < breaks.length) {
                knots[j] = breaks[i];
                ++i;
                ++j;
            }
            i = 0;
            j = n - km1;
            while (i < km1) {
                knots[i] = breaks[j] - P;
                ++i;
                ++j;
            }
            i = n + km1;
            j = 0;
            while (i < knots.length) {
                knots[i] = breaks[j] + P;
                ++i;
                ++j;
            }
            return new BSpline(k, n, knots, P);
        }

        private static void checkBreaks(double[] breaks, double P) {
            int i;
            if (P > 0.0) {
                for (i = 0; i < breaks.length; ++i) {
                    if (!(breaks[i] < 0.0) && !(breaks[i] >= P)) continue;
                    throw new IllegalArgumentException("Knots should be in [0, P[");
                }
            }
            for (i = 0; i < breaks.length - 1; ++i) {
                if (!(breaks[i + 1] < breaks[i])) continue;
                throw new DemetraException("Invalid knots in B-Spline");
            }
        }
    }
}

