/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.sts;

import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfDynamics;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.basic.Loading;
import lombok.Generated;

public final class PeriodicComponent {
    public static int dim(int nharmonics) {
        return nharmonics * 2;
    }

    public static StateComponent stateComponent(double period, int[] harmonics, double cvar) {
        Data data = new Data(period, harmonics, cvar);
        return new StateComponent(new Initialization(data), new Dynamics(data));
    }

    public static ISsfLoading defaultLoading(int k) {
        if (k == 1) {
            return Loading.fromPosition(0);
        }
        int[] pos = new int[k];
        int i = 0;
        int p = 0;
        while (i < k) {
            pos[i] = p;
            ++i;
            p += 2;
        }
        return Loading.fromPositions(pos);
    }

    @Generated
    private PeriodicComponent() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static class Data {
        private final double var;
        private final double period;
        private final int[] k;

        public Data(double period, int[] k, double var) {
            this.var = var;
            this.period = period;
            this.k = k;
        }
    }

    static class Initialization
    implements ISsfInitialization {
        final Data data;

        Initialization(Data data) {
            this.data = data;
        }

        @Override
        public boolean isDiffuse() {
            return true;
        }

        @Override
        public int getDiffuseDim() {
            return this.data.k.length * 2;
        }

        @Override
        public int getStateDim() {
            return this.data.k.length * 2;
        }

        @Override
        public void diffuseConstraints(FastMatrix b) {
            b.diagonal().set(1.0);
        }

        @Override
        public void a0(DataBlock a0) {
        }

        @Override
        public void Pf0(FastMatrix p) {
        }

        @Override
        public void Pi0(FastMatrix p) {
            p.diagonal().set(1.0);
        }
    }

    static class Dynamics
    implements ISsfDynamics {
        final Data data;
        private final double[] ccos;
        private final double[] csin;
        private double e;

        Dynamics(Data data) {
            this.data = data;
            this.e = Math.sqrt(data.var);
            double q = Math.PI * 2 / data.period;
            int nh = data.k.length;
            this.ccos = new double[nh];
            this.csin = new double[nh];
            for (int i = 0; i < nh; ++i) {
                double f = q * (double)data.k[i];
                this.ccos[i] = Math.cos(f);
                this.csin[i] = Math.sin(f);
            }
        }

        @Override
        public int getInnovationsDim() {
            return this.data.var == 0.0 ? 0 : 2 * this.data.k.length;
        }

        @Override
        public void V(int pos, FastMatrix v) {
            v.diagonal().set(this.data.var);
        }

        @Override
        public void S(int pos, FastMatrix s) {
            s.diagonal().set(this.e);
        }

        @Override
        public boolean hasInnovations(int pos) {
            return this.data.var != 0.0;
        }

        @Override
        public boolean areInnovationsTimeInvariant() {
            return true;
        }

        @Override
        public void T(int pos, FastMatrix tr) {
            int i = 0;
            int p = 0;
            while (i < this.data.k.length) {
                tr.set(p, p, this.ccos[i]);
                tr.set(p, p + 1, this.csin[i]);
                tr.set(p + 1, p, -this.csin[i]);
                tr.set(p + 1, p + 1, this.ccos[i]);
                ++i;
                p += 2;
            }
        }

        @Override
        public void TX(int pos, DataBlock x) {
            int i = 0;
            int p = 0;
            while (i < this.data.k.length) {
                double a = x.get(p);
                double b = x.get(p + 1);
                x.set(p, a * this.ccos[i] + b * this.csin[i]);
                x.set(p + 1, -a * this.csin[i] + b * this.ccos[i]);
                ++i;
                p += 2;
            }
        }

        @Override
        public void addSU(int pos, DataBlock x, DataBlock u) {
            x.addAY(this.e, u);
        }

        @Override
        public void addV(int pos, FastMatrix p) {
            p.diagonal().add(this.data.var);
        }

        @Override
        public void XT(int pos, DataBlock x) {
            int i = 0;
            int p = 0;
            while (i < this.data.k.length) {
                double a = x.get(p);
                double b = x.get(p + 1);
                x.set(p, a * this.ccos[i] - b * this.csin[i]);
                x.set(p + 1, a * this.csin[i] + b * this.ccos[i]);
                ++i;
                p += 2;
            }
        }

        @Override
        public void XS(int pos, DataBlock x, DataBlock xs) {
            xs.setAY(this.e, x);
        }

        @Override
        public boolean isTimeInvariant() {
            return true;
        }
    }
}

