## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(senseR)

## -----------------------------------------------------------------------------
# example
set.seed(123)

# Simulated dataset
df <- data.frame(
  gdp = rnorm(100, 10, 2),
  ntl = rnorm(100, 50, 10),
  road_density = rnorm(100, 3, 0.5),
  mobile_signal = rnorm(100, 70, 15)
)

# Run senser in English
senser(
  data = df,
  proxy = c("ntl", "road_density", "mobile_signal"),
  target = "gdp",
  lang = "english"
)

## -----------------------------------------------------------------------------
# Indonesian language support
senser(
  data = df,
  proxy = c("ntl", "road_density"),
  target = "gdp",
  lang = "indonesia"
)


