/*
 * Decompiled with CFR 0.152.
 */
package moa.streams;

import com.github.javacliparser.IntOption;
import com.yahoo.labs.samoa.instances.Instance;
import com.yahoo.labs.samoa.instances.InstancesHeader;
import java.util.Random;
import moa.core.Example;
import moa.core.InstanceExample;
import moa.core.MiscUtils;
import moa.core.ObjectRepository;
import moa.options.AbstractOptionHandler;
import moa.options.ClassOption;
import moa.streams.InstanceStream;
import moa.streams.MultiTargetArffFileStream;
import moa.streams.MultiTargetInstanceStream;
import moa.tasks.TaskMonitor;

public class BootstrappedStream
extends AbstractOptionHandler
implements InstanceStream,
MultiTargetInstanceStream {
    private static final long serialVersionUID = 1L;
    public ClassOption streamOption = new ClassOption("stream", 's', "Stream to filter.", MultiTargetInstanceStream.class, MultiTargetArffFileStream.class.getName());
    public IntOption randomSeedOption = new IntOption("randomSeed", 'r', "Seed for the random generator", 1);
    protected MultiTargetInstanceStream originalStream;
    protected int waitingToSend;
    protected Example<Instance> queuedInstance;
    protected Random randomGenerator = new Random();

    @Override
    public InstancesHeader getHeader() {
        InstancesHeader h = null;
        if (this.originalStream != null) {
            h = this.originalStream.getHeader();
        }
        return h;
    }

    @Override
    public long estimatedRemainingInstances() {
        if (this.originalStream != null) {
            return this.originalStream.estimatedRemainingInstances();
        }
        return 0L;
    }

    @Override
    public boolean hasMoreInstances() {
        boolean flag = false;
        if (this.originalStream != null && (this.waitingToSend > 0 || this.originalStream.hasMoreInstances())) {
            flag = true;
        }
        return flag;
    }

    @Override
    public Example<Instance> nextInstance() {
        if (this.waitingToSend == 0) {
            do {
                this.queuedInstance = this.originalStream.nextInstance();
                this.waitingToSend = MiscUtils.poisson(1.0, this.randomGenerator);
            } while (this.waitingToSend == 0);
        }
        InstanceExample instance = new InstanceExample(this.queuedInstance.getData().copy());
        instance.setWeight(this.queuedInstance.weight());
        --this.waitingToSend;
        return instance;
    }

    @Override
    public boolean isRestartable() {
        return true;
    }

    @Override
    public void restart() {
        this.originalStream = (MultiTargetInstanceStream)this.getPreparedClassOption(this.streamOption);
        this.waitingToSend = 0;
        this.randomGenerator.setSeed(this.randomSeedOption.getValue());
        this.queuedInstance = null;
        this.originalStream.restart();
    }

    @Override
    public void getDescription(StringBuilder sb, int indent) {
    }

    @Override
    protected void prepareForUseImpl(TaskMonitor monitor, ObjectRepository repository) {
        this.restart();
    }
}

