/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.arg.operators;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.TreeUtils;
import dr.evomodel.arg.ARGModel;
import dr.evomodel.arg.operators.ARGOperatorFailedException;
import dr.evomodel.arg.operators.ObsoleteARGAddRemoveEventOperator;
import dr.inference.model.CompoundParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.math.MathUtils;
import dr.math.functionEval.GammaFunction;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class ObsoleteARGNewEventOperator
extends AbstractAdaptableOperator {
    public static final String SUBTREE_SLIDE = "newARGEvent";
    public static final String SWAP_RATES = "swapRates";
    public static final String SWAP_TRAITS = "swapTraits";
    public static final String MAX_VALUE = "maxTips";
    public static final String SINGLE_PARTITION = "singlePartitionProbability";
    public static final String IS_RECOMBINATION = "isRecombination";
    public static final String JUST_INTERNAL = "justInternalNodes";
    public static final String INTERNAL_AND_ROOT = "internalAndRootNodes";
    public static final String NODE_RATES = "nodeRates";
    private ARGModel arg = null;
    private double size = 1.0;
    private boolean gaussian = false;
    private double singlePartitionProbability = 0.0;
    private boolean isRecombination = false;
    private CompoundParameter internalNodeParameters;
    private CompoundParameter internalAndRootNodeParameters;
    private CompoundParameter nodeRates;
    private int times = 0;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newIntegerRule("weight"), AttributeRule.newDoubleRule("size"), AttributeRule.newBooleanRule("gaussian"), AttributeRule.newBooleanRule("swapRates", true), AttributeRule.newBooleanRule("swapTraits", true), AttributeRule.newBooleanRule("autoOptimize", true), new ElementRule(ARGModel.class)};

        @Override
        public String getParserName() {
            return ObsoleteARGNewEventOperator.SUBTREE_SLIDE;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            boolean bl = false;
            boolean bl2 = false;
            double d = 0.0;
            boolean bl3 = false;
            AdaptationMode adaptationMode = AdaptationMode.parseMode(xMLObject);
            if (xMLObject.hasAttribute(ObsoleteARGNewEventOperator.SINGLE_PARTITION)) {
                d = xMLObject.getDoubleAttribute(ObsoleteARGNewEventOperator.SINGLE_PARTITION);
            }
            if (xMLObject.hasAttribute(ObsoleteARGNewEventOperator.IS_RECOMBINATION)) {
                bl3 = xMLObject.getBooleanAttribute(ObsoleteARGNewEventOperator.IS_RECOMBINATION);
            }
            if (xMLObject.hasAttribute(ObsoleteARGNewEventOperator.SWAP_RATES)) {
                bl = xMLObject.getBooleanAttribute(ObsoleteARGNewEventOperator.SWAP_RATES);
            }
            if (xMLObject.hasAttribute(ObsoleteARGNewEventOperator.SWAP_TRAITS)) {
                bl2 = xMLObject.getBooleanAttribute(ObsoleteARGNewEventOperator.SWAP_TRAITS);
            }
            Object object = xMLObject.getChild(ARGModel.class);
            ARGModel aRGModel = null;
            if (object instanceof ARGModel) {
                aRGModel = (ARGModel)object;
            } else {
                System.err.println("Must specify a variable size tree model to use the AddRemoveSubtreeOperators");
                System.exit(-1);
            }
            CompoundParameter compoundParameter = null;
            CompoundParameter compoundParameter2 = null;
            CompoundParameter compoundParameter3 = null;
            int n = xMLObject.getIntegerAttribute("weight");
            double d2 = xMLObject.getDoubleAttribute("size");
            boolean bl4 = xMLObject.getBooleanAttribute("gaussian");
            return new ObsoleteARGNewEventOperator(aRGModel, n, d2, bl4, bl, bl2, adaptationMode, compoundParameter, compoundParameter2, compoundParameter3, d, bl3);
        }

        @Override
        public String getParserDescription() {
            return "An operator that slides a subarg.";
        }

        @Override
        public Class getReturnType() {
            return ObsoleteARGAddRemoveEventOperator.class;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }
    };

    public ObsoleteARGNewEventOperator(ARGModel aRGModel, int n, double d, boolean bl, boolean bl2, boolean bl3, AdaptationMode adaptationMode, CompoundParameter compoundParameter, CompoundParameter compoundParameter2, CompoundParameter compoundParameter3, double d2, boolean bl4) {
        super(adaptationMode);
        this.arg = aRGModel;
        this.setWeight(n);
        this.size = d;
        this.gaussian = bl;
        this.internalNodeParameters = compoundParameter;
        this.internalAndRootNodeParameters = compoundParameter2;
        this.nodeRates = compoundParameter3;
        this.singlePartitionProbability = d2;
        this.isRecombination = bl4;
    }

    @Override
    public double doOperation() {
        double d;
        block2: {
            d = 0.0;
            try {
                d = MathUtils.nextDouble() < 0.5 ? this.AddOperation() : this.RemoveOperation();
            }
            catch (Exception exception) {
                if (exception.getMessage().compareTo("No reassortment nodes to remove.") == 0) break block2;
                System.err.println("Catch: " + exception.getMessage());
                System.exit(-1);
            }
        }
        return d;
    }

    private int findPotentialNodesToRemove(ArrayList<NodeRef> arrayList) {
        int n = 0;
        int n2 = this.arg.getNodeCount();
        ARGModel.Node node = (ARGModel.Node)this.arg.getRoot();
        for (int i = 0; i < n2; ++i) {
            ARGModel.Node node2 = (ARGModel.Node)this.arg.getNode(i);
            if (!node2.isReassortment() || (node2.leftParent == node || !node2.leftParent.isBifurcation()) && (node2.rightParent == node || !node2.rightParent.isBifurcation())) continue;
            if (arrayList != null) {
                arrayList.add(node2);
            }
            ++n;
        }
        return n;
    }

    private double RemoveOperation() throws ARGOperatorFailedException {
        ARGModel.Node node;
        double d = 0.0;
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
        int n = this.findPotentialNodesToRemove(arrayList);
        if (n == 0) {
            throw new ARGOperatorFailedException("No reassortment nodes to remove.");
        }
        ARGModel.Node node2 = (ARGModel.Node)arrayList.get(MathUtils.nextInt(n));
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.arg.getNodeHeight(this.arg.getRoot());
        d2 = this.arg.getNodeHeight(node2);
        this.arg.beginTreeEdit();
        boolean bl = false;
        ARGModel.Node node3 = node2.leftParent;
        ARGModel.Node node4 = node2.leftChild;
        if (node2.leftParent == node2.rightParent) {
            node = node3.leftParent;
            this.arg.doubleRemoveChild(node, node3);
            this.arg.doubleRemoveChild(node2, node4);
            if (node.bifurcation) {
                this.arg.singleAddChild(node, node4);
            } else {
                this.arg.doubleAddChild(node, node4);
            }
            bl = true;
        } else {
            node = node2.leftParent;
            ARGModel.Node node5 = node2.rightParent;
            if (!node.bifurcation || node.isRoot()) {
                node = node2.rightParent;
                node5 = node2.leftParent;
            } else if (node5.bifurcation && !node5.isRoot()) {
                if (MathUtils.nextDouble() < 0.5) {
                    node = node2.rightParent;
                    node5 = node2.leftParent;
                }
                d += Math.log(2.0);
            }
            ARGModel.Node node6 = node.leftParent;
            ARGModel.Node node7 = node.leftChild;
            if (node7 == node2) {
                node7 = node.rightChild;
            }
            if (node6.bifurcation) {
                this.arg.singleRemoveChild(node6, node);
            } else {
                this.arg.doubleRemoveChild(node6, node);
            }
            this.arg.singleRemoveChild(node, node7);
            if (node5.bifurcation) {
                this.arg.singleRemoveChild(node5, node2);
            } else {
                this.arg.doubleRemoveChild(node5, node2);
            }
            this.arg.doubleRemoveChild(node2, node4);
            if (node7 != node4) {
                if (node6.bifurcation) {
                    this.arg.singleAddChild(node6, node7);
                } else {
                    this.arg.doubleAddChild(node6, node7);
                }
                if (node5.bifurcation) {
                    this.arg.singleAddChild(node5, node4);
                } else {
                    this.arg.doubleAddChild(node5, node4);
                }
            } else {
                if (node6.bifurcation) {
                    this.arg.singleAddChildWithOneParent(node6, node7);
                } else {
                    this.arg.doubleAddChildWithOneParent(node6, node7);
                }
                if (node5.bifurcation) {
                    this.arg.singleAddChildWithOneParent(node5, node4);
                } else {
                    this.arg.doubleAddChildWithOneParent(node5, node4);
                }
            }
            bl = true;
            node3 = node;
        }
        d3 = this.arg.getNodeHeight(node3);
        if (bl) {
            try {
                this.arg.contractARGWithRecombinant(node3, node2, this.internalNodeParameters, this.internalAndRootNodeParameters, this.nodeRates);
            }
            catch (Exception exception) {
                System.err.println("here");
                System.err.println(exception);
            }
        }
        this.arg.pushTreeSizeChangedEvent();
        this.arg.endTreeEdit();
        d = 0.0;
        return d;
    }

    private static double lnGamma(double d) {
        if (d == 1.0 || d == 2.0) {
            return 0.0;
        }
        return GammaFunction.logGamma(d);
    }

    private void checkAllHeights() {
        int n;
        int n2 = this.arg.getInternalNodeCount();
        System.err.println("# internal nodes = " + n2);
        int n3 = this.internalNodeParameters.getParameterCount();
        System.err.println("VSCP (" + n3 + ")");
        for (n = 0; n < n3; ++n) {
            System.err.println(this.internalNodeParameters.getParameterValue(n));
        }
        n3 = this.arg.getInternalNodeCount();
        System.err.println("Checking all internal nodes (" + n3 + ") via tree:");
        for (n = 0; n < n3; ++n) {
            NodeRef nodeRef = this.arg.getInternalNode(n);
            System.err.print(TreeUtils.uniqueNewick(this.arg, nodeRef) + " ");
            System.err.println(((ARGModel.Node)nodeRef).getHeight());
        }
    }

    private int findPotentialAttachmentPoints(double d, ArrayList<NodeRef> arrayList) {
        int n = 0;
        int n2 = this.arg.getNodeCount();
        for (int i = 0; i < n2; ++i) {
            NodeRef nodeRef = this.arg.getNode(i);
            if (this.arg.isRoot(nodeRef) || !(this.arg.getNodeHeight(nodeRef) < d)) continue;
            if (this.arg.getNodeHeight(this.arg.getParent(nodeRef, 0)) > d) {
                if (arrayList != null) {
                    arrayList.add(nodeRef);
                }
                ++n;
            }
            if (!this.arg.isReassortment(nodeRef) || !(this.arg.getNodeHeight(this.arg.getParent(nodeRef, 1)) > d)) continue;
            if (arrayList != null) {
                arrayList.add(nodeRef);
            }
            ++n;
        }
        return n;
    }

    private double drawRandomPartitioning(Parameter parameter) {
        double d = 0.0;
        int n = this.arg.getNumberOfPartitions();
        if (n == 2) {
            if (parameter != null) {
                if (MathUtils.nextBoolean()) {
                    parameter.setParameterValueQuietly(0, 1.0);
                } else {
                    parameter.setParameterValueQuietly(1, 1.0);
                }
            }
            return Math.log(2.0);
        }
        d = this.isRecombination ? (d += this.drawRandomRecombination(parameter)) : (d += this.drawRandomReassortment(parameter));
        return d;
    }

    private double drawRandomReassortment(Parameter parameter) {
        int n = this.arg.getNumberOfPartitions();
        double d = 0.0;
        if (MathUtils.nextDouble() < this.singlePartitionProbability) {
            if (parameter != null) {
                parameter.setParameterValueQuietly(MathUtils.nextInt(n), 1.0);
            }
            return Math.log(n);
        }
        int[] nArray = MathUtils.permuted(n);
        int n2 = MathUtils.nextInt(n - 1);
        for (int i = 0; i < n; ++i) {
            d += Math.log(i + 1);
            if (i <= n2 || parameter == null) continue;
            parameter.setParameterValueQuietly(nArray[i], 1.0);
        }
        return d += Math.log(n - 1);
    }

    private double drawRandomRecombination(Parameter parameter) {
        int n = this.arg.getNumberOfPartitions();
        double d = 0.0;
        double d2 = MathUtils.nextInt(2);
        double d3 = 1.0 - d2;
        d += Math.log(2.0);
        if (parameter != null) {
            int n2;
            int n3 = MathUtils.nextInt(n - 1);
            for (n2 = 0; n2 <= n3; ++n2) {
                parameter.setParameterValueQuietly(n2, d2);
            }
            for (n2 = n3 + 1; n2 < n; ++n2) {
                parameter.setParameterValueQuietly(n2, d3);
            }
        }
        return d += Math.log(n - 1);
    }

    private double AddOperation() throws ARGOperatorFailedException {
        double d = 0.0;
        ArrayList<NodeRef> arrayList = new ArrayList<NodeRef>();
        ArrayList<NodeRef> arrayList2 = new ArrayList<NodeRef>();
        double d2 = this.arg.getNodeHeight(this.arg.getRoot());
        double d3 = d2 * MathUtils.nextDouble();
        double d4 = d2 * MathUtils.nextDouble();
        if (d4 > d3) {
            double d5 = d4;
            d4 = d3;
            d3 = d5;
        }
        int n = this.findPotentialAttachmentPoints(d3, arrayList);
        int n2 = this.findPotentialAttachmentPoints(d4, arrayList2);
        if (n == 0 || n2 == 0) {
            throw new RuntimeException("Unable to find attachment points.");
        }
        ARGModel.Node node = (ARGModel.Node)arrayList2.get(MathUtils.nextInt(n2));
        ARGModel.Node node2 = node.leftParent;
        ARGModel.Node node3 = node.rightParent;
        ARGModel.Node node4 = node2;
        if (node2 != node3) {
            if (this.arg.getNodeHeight(node2) < d4) {
                node4 = node3;
            } else if (this.arg.getNodeHeight(node3) > d4 && MathUtils.nextDouble() > 0.5) {
                node4 = node3;
            }
        }
        ARGModel.Node node5 = (ARGModel.Node)arrayList.get(MathUtils.nextInt(n));
        ARGModel.Node node6 = node5.leftParent;
        ARGModel.Node node7 = node5.rightParent;
        ARGModel.Node node8 = node6;
        if (node6 != node7) {
            if (this.arg.getNodeHeight(node6) < d3) {
                node8 = node7;
            } else if (this.arg.getNodeHeight(node7) > d3 && MathUtils.nextDouble() > 0.5) {
                node8 = node7;
            }
        }
        double d6 = 1.0;
        double d7 = 1.0;
        ARGModel.Node node9 = this.arg.new ARGModel.Node();
        node9.heightParameter = new Parameter.Default(d3);
        node9.rateParameter = new Parameter.Default(d6);
        node9.setupHeightBounds();
        ARGModel.Node node10 = this.arg.new ARGModel.Node();
        node10.bifurcation = false;
        node10.heightParameter = new Parameter.Default(d4);
        node10.rateParameter = new Parameter.Default(d7);
        node10.setupHeightBounds();
        this.arg.beginTreeEdit();
        if (node8.bifurcation) {
            this.arg.singleRemoveChild(node8, node5);
        } else {
            this.arg.doubleRemoveChild(node8, node5);
        }
        if (node5 != node) {
            if (node4.bifurcation) {
                this.arg.singleRemoveChild(node4, node);
            } else {
                this.arg.doubleRemoveChild(node4, node);
            }
        }
        if (node8.bifurcation) {
            this.arg.singleAddChild(node8, node9);
        } else {
            this.arg.doubleAddChild(node8, node9);
        }
        if (node5 != node) {
            this.arg.singleAddChild(node9, node5);
        }
        this.arg.doubleAddChild(node10, node);
        Parameter.Default default_ = new Parameter.Default(this.arg.getNumberOfPartitions());
        this.drawRandomPartitioning(default_);
        if (node5 != node) {
            this.arg.addChildAsRecombinant(node9, node4, node10, default_);
        } else {
            this.arg.addChildAsRecombinant(node9, node9, node10, default_);
        }
        this.arg.expandARGWithRecombinant(node9, node10, this.internalNodeParameters, this.internalAndRootNodeParameters, this.nodeRates);
        this.arg.pushTreeSizeChangedEvent();
        this.arg.endTreeEdit();
        d = 0.0;
        return d;
    }

    public void sanityCheck() {
        int n = this.arg.getNodeCount();
        for (int i = 0; i < n; ++i) {
            ARGModel.Node node = (ARGModel.Node)this.arg.getNode(i);
            if (node.bifurcation) {
                boolean bl;
                boolean bl2 = bl = node.leftChild == node.rightChild;
                if (bl && node.leftChild != null && (node.leftChild.bifurcation || node.leftChild.leftParent != node)) {
                    System.err.println("Node " + (i + 1) + " is insane.");
                    System.err.println(this.arg.toGraphString());
                    System.exit(-1);
                }
            } else if (node.leftChild != node.rightChild) {
                System.err.println("Node " + (i + 1) + " is insane.");
                System.err.println(this.arg.toGraphString());
                System.exit(-1);
            }
            if (node.isRoot()) continue;
            double d = node.getHeight();
        }
    }

    private double getDelta() {
        if (!this.gaussian) {
            return MathUtils.nextDouble() * this.size - this.size / 2.0;
        }
        return MathUtils.nextGaussian() * this.size;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double d) {
        this.size = d;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.getSize());
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.setSize(Math.exp(d));
    }

    @Override
    public double getRawParameter() {
        return this.getSize();
    }

    @Override
    public String getAdaptableParameterName() {
        return "size";
    }

    @Override
    public String getOperatorName() {
        return SUBTREE_SLIDE;
    }
}

