/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.circe.check.checkers;

import java.util.Objects;
import java.util.function.Consumer;
import org.ohdsi.circe.check.checkers.BaseCheckerFactory;
import org.ohdsi.circe.check.checkers.WarningReporter;
import org.ohdsi.circe.check.operations.Operations;
import org.ohdsi.circe.cohortdefinition.ConditionOccurrence;
import org.ohdsi.circe.cohortdefinition.Criteria;
import org.ohdsi.circe.cohortdefinition.DemographicCriteria;
import org.ohdsi.circe.cohortdefinition.DeviceExposure;
import org.ohdsi.circe.cohortdefinition.DrugExposure;
import org.ohdsi.circe.cohortdefinition.Observation;
import org.ohdsi.circe.cohortdefinition.Specimen;
import org.ohdsi.circe.cohortdefinition.TextFilter;

public class TextCheckerFactory
extends BaseCheckerFactory {
    private static final String WARNING_EMPTY_VALUE = "%s in the %s has empty %s value";

    private TextCheckerFactory(WarningReporter reporter, String groupName) {
        super(reporter, groupName);
    }

    public static TextCheckerFactory getFactory(WarningReporter reporter, String groupName) {
        return new TextCheckerFactory(reporter, groupName);
    }

    @Override
    protected Consumer<Criteria> getCheck(Criteria criteria) {
        Consumer<Criteria> result = c -> {};
        if (criteria instanceof ConditionOccurrence) {
            result = c -> {
                ConditionOccurrence co = (ConditionOccurrence)c;
                this.checkText(co.stopReason, "condition occurrence", "stop reason");
            };
        } else if (criteria instanceof DeviceExposure) {
            result = c -> {
                DeviceExposure de = (DeviceExposure)c;
                this.checkText(de.uniqueDeviceId, "device exposure", "unique device id");
            };
        } else if (criteria instanceof DrugExposure) {
            result = c -> {
                DrugExposure de = (DrugExposure)c;
                this.checkText(de.stopReason, "drug exposure", "stop reason");
                this.checkText(de.lotNumber, "drug exposure", "lot number");
            };
        } else if (criteria instanceof Observation) {
            result = c -> {
                Observation o = (Observation)c;
                this.checkText(o.valueAsString, "observation", "value as string");
            };
        } else if (criteria instanceof Specimen) {
            result = c -> {
                Specimen specimen = (Specimen)c;
                this.checkText(specimen.sourceId, "specimen", "source id");
            };
        }
        return result;
    }

    @Override
    protected Consumer<DemographicCriteria> getCheck(DemographicCriteria criteria) {
        return c -> {};
    }

    private void checkText(TextFilter text, String criteriaName, String attribute) {
        Consumer<String> warning = t -> this.reporter.add((String)t, this.groupName, criteriaName, attribute);
        Operations.match(text).when(r -> Objects.nonNull(r) && Objects.isNull(r.text)).then(() -> warning.accept(WARNING_EMPTY_VALUE));
    }
}

