/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.aeprocessor.aeoptimizer;

import com.amazon.sqlengine.aeprocessor.aeoptimizer.AEPassdownFilter;
import com.amazon.sqlengine.aeprocessor.aetree.AETreeWalker;
import com.amazon.sqlengine.aeprocessor.aetree.IAENode;
import com.amazon.sqlengine.aeprocessor.aetree.bool.AEBooleanExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AEJoin;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AENamedRelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AERelationalExpr;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AESelect;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AESubQuery;
import com.amazon.sqlengine.aeprocessor.aetree.relation.AETable;
import com.amazon.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.amazon.sqlengine.dsiext.dataengine.DSIExtJResultSet;
import com.amazon.sqlengine.dsiext.dataengine.DSIExtOperationHandlerFactory;
import com.amazon.sqlengine.dsiext.dataengine.IBooleanExprHandler;
import com.amazon.support.Pair;
import com.amazon.support.exceptions.ErrorException;

public class AEPassdownJoin {
    private DSIExtOperationHandlerFactory m_opHandlerFactory;

    public AEPassdownJoin(DSIExtOperationHandlerFactory dSIExtOperationHandlerFactory) {
        assert (null != dSIExtOperationHandlerFactory);
        this.m_opHandlerFactory = dSIExtOperationHandlerFactory;
    }

    public AERelationalExpr passdown(AEJoin aEJoin) {
        Object object;
        assert (null != aEJoin);
        assert (aEJoin.getLeftOperand() instanceof AETable);
        assert (aEJoin.getRightOperand() instanceof AETable);
        AETable aETable = (AETable)aEJoin.getLeftOperand();
        AETable aETable2 = (AETable)aEJoin.getRightOperand();
        IBooleanExprHandler iBooleanExprHandler = this.m_opHandlerFactory.createJoinHandler(aETable.getTable(), aETable2.getTable(), aEJoin.getJoinType());
        if (null == iBooleanExprHandler) {
            return null;
        }
        AEBooleanExpr aEBooleanExpr = aEJoin.getJoinCondition();
        DSIExtJResultSet dSIExtJResultSet = null;
        if (AEJoin.AEJoinType.INNER_JOIN == aEJoin.getJoinType()) {
            object = new AEPassdownFilter(iBooleanExprHandler).passdown(aEBooleanExpr);
            dSIExtJResultSet = ((Pair)object).key();
            aEBooleanExpr = ((Pair)object).value();
        } else if (iBooleanExprHandler.passdown(aEJoin.getJoinCondition())) {
            dSIExtJResultSet = iBooleanExprHandler.takeResult();
            aEBooleanExpr = null;
        }
        if (dSIExtJResultSet == null) {
            return null;
        }
        try {
            object = new AETable(dSIExtJResultSet);
            ((AENamedRelationalExpr)object).overrideCorrelationSpec(aETable, aETable2, null);
            this.resolveColumns(aETable, (AETable)object);
            this.resolveColumns(aETable2, (AETable)object);
            if (null == aEBooleanExpr) {
                return object;
            }
            return this.passdownJoinCond(aEBooleanExpr, (AETable)object);
        }
        catch (ErrorException errorException) {
            return null;
        }
    }

    private AERelationalExpr passdownJoinCond(AEBooleanExpr aEBooleanExpr, AETable aETable) {
        assert (null != aETable);
        assert (null != aETable.getTable());
        IBooleanExprHandler iBooleanExprHandler = this.m_opHandlerFactory.createFilterHandler(aETable.getTable());
        if (null == iBooleanExprHandler) {
            return new AESelect(aETable, aEBooleanExpr);
        }
        Pair<DSIExtJResultSet, AEBooleanExpr> pair = new AEPassdownFilter(iBooleanExprHandler).passdown(aEBooleanExpr);
        if (null != pair.key()) {
            aETable.setTable(pair.key());
        }
        if (pair.value() == null) {
            return aETable;
        }
        return new AESelect(aETable, aEBooleanExpr);
    }

    private void resolveColumns(AETable aETable, AETable aETable2) throws ErrorException {
        IAENode iAENode = aETable.getParent();
        while (iAENode.getParent() != null && !(iAENode instanceof AESubQuery)) {
            iAENode = iAENode.getParent();
        }
        DSIExtJResultSet dSIExtJResultSet = aETable2.getTable();
        DSIExtJResultSet dSIExtJResultSet2 = aETable.getTable();
        AETreeWalker aETreeWalker = new AETreeWalker(iAENode);
        while (aETreeWalker.hasNext()) {
            AEColumnReference aEColumnReference;
            IAENode iAENode2 = aETreeWalker.next();
            if (!(iAENode2 instanceof AEColumnReference) || (aEColumnReference = (AEColumnReference)iAENode2).getNamedRelationalExpr() != aETable) continue;
            aEColumnReference.setNamedRelationalExpr(aETable2);
            int n = dSIExtJResultSet.resolveColumn(dSIExtJResultSet2, aEColumnReference.getColumnNum());
            aEColumnReference.setColumnNum(n);
        }
    }
}

