/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.propagation;

import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.solver.Configuration;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.SConstraint;
import choco.kernel.solver.propagation.Propagator;
import choco.kernel.solver.propagation.listener.PropagationEngineListener;
import choco.kernel.solver.search.measure.FailMeasure;
import choco.kernel.solver.variables.Var;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.real.RealVar;
import choco.kernel.solver.variables.set.SetVar;
import java.util.logging.Logger;

public interface PropagationEngine {
    public static final Logger LOGGER = ChocoLogging.getEngineLogger();

    public FailMeasure getFailMeasure();

    public void clear();

    public void loadSettings(Configuration var1);

    public void raiseContradiction(Object var1) throws ContradictionException;

    public void raiseContradiction(Object var1, int var2) throws ContradictionException;

    @Deprecated
    public void raiseContradiction(int var1, Var var2, SConstraint var3) throws ContradictionException;

    public void flushEvents();

    public boolean checkCleanState();

    public void postEvent(Var var1, int var2, SConstraint var3, boolean var4);

    public void postUpdateInf(IntDomainVar var1, SConstraint var2, boolean var3);

    public void postUpdateSup(IntDomainVar var1, SConstraint var2, boolean var3);

    public void postInstInt(IntDomainVar var1, SConstraint var2, boolean var3);

    public void postRemoveVal(IntDomainVar var1, int var2, SConstraint var3, boolean var4);

    public void postUpdateInf(RealVar var1, SConstraint var2, boolean var3);

    public void postUpdateSup(RealVar var1, SConstraint var2, boolean var3);

    public void postRemEnv(SetVar var1, SConstraint var2, boolean var3);

    public void postAddKer(SetVar var1, SConstraint var2, boolean var3);

    public void postInstSet(SetVar var1, SConstraint var2, boolean var3);

    public boolean postConstAwake(Propagator var1, boolean var2);

    public void registerPropagator(Propagator var1);

    public void desactivatePropagator(Propagator var1);

    public void propagateEvents() throws ContradictionException;

    public void decPendingInitConstAwakeEvent();

    public void incPendingInitConstAwakeEvent();

    public void freeze();

    public void unfreeze();

    public void addPropagationEngineListener(PropagationEngineListener var1);

    public void removePropagationEngineListener(PropagationEngineListener var1);

    public boolean containsPropagationListener(PropagationEngineListener var1);
}

