/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.files.diff.ui;

import com.qarks.util.files.diff.ui.MergeItem;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MergeContentPanel
extends JPanel {
    private ArrayList<MergeItem> mergeItems = new ArrayList();

    public MergeContentPanel() {
        this.setLayout(null);
        this.setOpaque(true);
        this.setBackground(Color.white);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                MergeContentPanel.this.setItemsBounds();
            }
        });
    }

    public void clear() {
        this.mergeItems.clear();
        this.removeAll();
        this.invalidate();
        this.getParent().validate();
    }

    public String getMergedFileContent() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        for (MergeItem object2 : this.mergeItems) {
            String i = object2.getContent();
            stringBuffer.append(i);
            if (i.endsWith(string)) continue;
            stringBuffer.append(string);
        }
        Object object = stringBuffer.toString();
        if (!string.equals("\n")) {
            stringBuffer = new StringBuffer();
            char[] cArray = ((String)object).toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c == '\n' && (i == 0 || cArray[i - 1] != '\r')) {
                    stringBuffer.append(string);
                    continue;
                }
                stringBuffer.append(c);
            }
            object = stringBuffer.toString();
        }
        return object;
    }

    protected void setItemsBounds() {
        int n = this.getSize().width;
        int n2 = 0;
        for (MergeItem mergeItem : this.mergeItems) {
            JComponent jComponent = (JComponent)((Object)mergeItem);
            Dimension dimension = jComponent.getPreferredSize();
            try {
                jComponent.setBounds(0, n2, n, dimension.height);
            }
            catch (Throwable throwable) {
                System.err.println(throwable.getMessage());
            }
            n2 += dimension.height;
        }
        super.invalidate();
        this.getParent().validate();
    }

    public void setViewPosition(int n) {
        for (MergeItem mergeItem : this.mergeItems) {
            mergeItem.setViewPosition(n);
        }
        this.repaint();
    }

    public Dimension getRealPreferredSize() {
        Dimension dimension = new Dimension(0, 0);
        for (MergeItem mergeItem : this.mergeItems) {
            Dimension dimension2 = mergeItem.getRealPreferredSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height += dimension2.height;
        }
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(0, 0);
        for (MergeItem mergeItem : this.mergeItems) {
            JComponent jComponent = (JComponent)((Object)mergeItem);
            Dimension dimension2 = jComponent.getPreferredSize();
            dimension.width = Math.max(dimension.width, dimension2.width);
            dimension.height += dimension2.height;
        }
        return dimension;
    }

    public void addMergeItem(MergeItem mergeItem) {
        if (mergeItem instanceof JComponent) {
            this.add((JComponent)((Object)mergeItem));
            this.mergeItems.add(mergeItem);
        }
    }

    @Override
    public void invalidate() {
    }
}

