/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class GenerateFoldsConfig {
    private static final Logger LOGGER = Logger.getLogger(GenerateFoldsConfig.class.getName());
    String basePath;
    String dataPath;
    String datasetNameWithoutSuffix;
    int foldCount;
    String emptyValue;

    public GenerateFoldsConfig(String path) throws FileNotFoundException, IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        BufferedInputStream input = new BufferedInputStream(new FileInputStream(path));
        Properties prop = new Properties();
        prop.loadFromXML(input);
        this.dataPath = prop.getProperty("DataPath");
        this.emptyValue = prop.getProperty("EmptyValue");
        if ("".equals(this.emptyValue)) {
            this.emptyValue = null;
        }
        this.foldCount = Integer.parseInt(prop.getProperty("FoldCount"));
        File f = new File(this.dataPath);
        this.basePath = new File(f.getParent()).getParent();
        this.datasetNameWithoutSuffix = f.getName().replace(".csv", "");
    }

    public String getEmptyValue() {
        return this.emptyValue;
    }

    public int getFoldCount() {
        return this.foldCount;
    }

    public String getTestOutputPath(int i) {
        return this.basePath + File.separator + "test" + File.separator + this.datasetNameWithoutSuffix + (i + 1) + ".csv";
    }

    public String getTrainOutputPath(int i) {
        return this.basePath + File.separator + "train" + File.separator + this.datasetNameWithoutSuffix + (i + 1) + ".csv";
    }

    public String getInputPath() {
        return this.dataPath;
    }
}

