## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(recastlessons)

## -----------------------------------------------------------------------------
dplyr::glimpse(R123)
str(TPL)

## -----------------------------------------------------------------------------
cls_quasihom(R123) %>% head(3)

## -----------------------------------------------------------------------------
prof_2days(R123, "10A", "Vi", "Mi")

## -----------------------------------------------------------------------------
coupled_dis(R123)

## ----eval=FALSE---------------------------------------------------------------
#  > DZ <- change_day(R123, "In2In1", "10A", "Vi", "Mi")

## -----------------------------------------------------------------------------
coupled_list(R123)[["In1"]]

## ----eval=FALSE---------------------------------------------------------------
#  > addmargins(table(DZ[c('cls','zl')]))["Sum", ]

## ----eval=FALSE---------------------------------------------------------------
#  prof_bad_dis(DZ)

## ----eval=FALSE---------------------------------------------------------------
#  > cls2prof(DZ, "ET1")

## ----eval=FALSE---------------------------------------------------------------
#  > prof_swap(DZ, "ET1", "Lu", "Jo")

## ----eval=FALSE---------------------------------------------------------------
#  > DZ <- change_day(DZ, "ET1", "8A", "Lu", "Jo")
#  > DZ <- change_day(DZ, "Ro4", "8A", "Jo", "Lu")
#  > saveRDS(DZ, "../adjR123.RDS")  # salvăm din când în când, repartiția curentă

## -----------------------------------------------------------------------------
library(dplyr, warn.conflicts = FALSE)
Tpl_prof <- TPL %>% pull(prof) %>% unique() %>%
    sapply(function(P) strsplit(P, " ")[[1]]) %>% 
    unlist() %>% unique()
DZ %>% filter(prof %in% Tpl_prof) %>% 
    tidy2tsv() %>% select(1:5)  # câte coloane încap aici...

