/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.data;

import java.util.Arrays;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;

public class DataBlockStorage {
    private double[] storage;
    private int n;
    private int nused;
    private final int dim;
    private static final int ATOM = 16;

    public static int calcSize(int capacity) {
        return (1 + (capacity - 1) / 16) * 16;
    }

    public DataBlockStorage(int dim, int capacity) {
        this.n = DataBlockStorage.calcSize(capacity);
        this.dim = dim;
        this.storage = new double[this.dim * this.n];
    }

    public DataBlock block(int pos) {
        int start = this.dim * pos;
        return DataBlock.of(this.storage, start, start + this.dim, 1);
    }

    public int getCapacity() {
        return this.n;
    }

    public int getCurrentSize() {
        return this.nused;
    }

    public int getDim() {
        return this.dim;
    }

    public DataBlock item(int index) {
        return DataBlock.of(this.storage, index, index + this.dim * this.nused, this.dim);
    }

    public void resize(int ncapacity) {
        int sz = DataBlockStorage.calcSize(ncapacity);
        if (sz <= this.n) {
            return;
        }
        double[] data = new double[this.dim * sz];
        System.arraycopy(this.storage, 0, data, 0, this.storage.length);
        this.storage = data;
        this.n = sz;
    }

    public void resize(int ncapacity, double value) {
        int sz = DataBlockStorage.calcSize(ncapacity);
        if (sz <= this.n) {
            return;
        }
        double[] data = new double[this.dim * sz];
        Arrays.fill(data, this.storage.length, data.length, value);
        System.arraycopy(this.storage, 0, data, 0, this.storage.length);
        this.storage = data;
        this.n = sz;
    }

    public void save(int pos, DataBlock rc) {
        rc.copyTo(this.storage, pos * this.dim);
        if (pos >= this.nused) {
            this.nused = pos + 1;
        }
    }

    public void save(int pos, double[] v) {
        System.arraycopy(v, 0, this.storage, pos * this.dim, this.dim);
        if (pos >= this.nused) {
            this.nused = pos + 1;
        }
    }

    public DataBlock storage(int start, int end) {
        int p0 = this.dim * start;
        int p1 = this.dim * end;
        return DataBlock.of(this.storage, p0, p1, 1);
    }

    public double[] storage() {
        return this.storage;
    }

    public FastMatrix matrix(int start, int end) {
        return FastMatrix.builder(this.storage).nrows(this.dim).ncolumns(end - start).start(this.dim * start).columnIncrement(this.dim).build();
    }

    public FastMatrix matrix() {
        return FastMatrix.builder(this.storage).nrows(this.dim).ncolumns(this.nused).columnIncrement(this.dim).build();
    }

    public void rescale(double factor) {
        if (factor == 1.0) {
            return;
        }
        int sz = this.dim * this.nused;
        int i = 0;
        while (i < sz) {
            int n = i++;
            this.storage[n] = this.storage[n] * factor;
        }
    }
}

