/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.random;

import jdplus.toolkit.base.core.random.AbstractRNG;

public class XorshiftRNG
extends AbstractRNG {
    private int m_x;
    private int m_y;
    private int m_z;
    private int m_w;
    private final int m_seed;
    private static final int Seed_Y = 362436069;
    private static final int Seed_Z = 521288629;
    private static final int Seed_W = 88675123;

    public static XorshiftRNG fromSystemNanoTime() {
        return new XorshiftRNG((int)System.nanoTime());
    }

    public XorshiftRNG(int seed) {
        this.m_seed = seed;
        this.resetGenerator();
    }

    public int nextInt() {
        int t = this.m_x ^ this.m_x << 11;
        this.m_x = this.m_y;
        this.m_y = this.m_z;
        this.m_z = this.m_w;
        this.m_w = this.m_w ^ this.m_w >>> 19 ^ (t ^ t >>> 8);
        return this.m_w;
    }

    private void resetGenerator() {
        this.m_x = this.m_seed;
        this.m_y = 362436069;
        this.m_z = 521288629;
        this.m_w = 88675123;
    }
}

