/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.regsarima.regular;

import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.AdditiveOutlierFactory;
import jdplus.toolkit.base.core.modelling.regression.LevelShiftFactory;
import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regarima.RegArimaModel;
import jdplus.toolkit.base.core.regarima.RegArimaUtility;
import jdplus.toolkit.base.core.regarima.outlier.FastOutlierDetector;
import jdplus.toolkit.base.core.regarima.outlier.SingleOutlierDetector;
import jdplus.toolkit.base.core.regsarima.ami.FastOutliersDetector;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.sarima.estimation.SarimaMapping;

public class RobustOutliersDetector {
    public static int DEF_MAXROUND = 20;
    public static int DEF_MAXOUTLIERS = 15;
    public static final double EPS = 1.0E-5;
    public static final double CV = 6.0;
    private final double eps;
    private final int maxOutliers;
    private final int maxRound;
    private final double cv;
    private int[][] outliers;

    public static Builder builder() {
        return new Builder();
    }

    private RobustOutliersDetector(Builder builder) {
        this.eps = builder.eps;
        this.maxOutliers = builder.maxOutliers;
        this.maxRound = builder.maxRound;
        this.cv = builder.cv;
    }

    private FastOutliersDetector make(DoubleSeq s) {
        FastOutliersDetector.Builder builder = FastOutliersDetector.builder().singleOutlierDetector(this.factories()).criticalValue(this.cv).maximumLikelihood(false).maxOutliers(this.maxOutliers).maxRound(this.maxRound).processor(RegArimaUtility.processor(true, this.eps));
        FastOutliersDetector impl = builder.build();
        int n = s.length();
        impl.prepare(n);
        impl.setBounds(0, n);
        return impl;
    }

    private SingleOutlierDetector<SarimaModel> factories() {
        FastOutlierDetector<SarimaModel> detector = new FastOutlierDetector<SarimaModel>(null);
        detector.setOutlierFactories(AdditiveOutlierFactory.FACTORY, LevelShiftFactory.FACTORY_ZEROENDED);
        return detector;
    }

    public DoubleSeq process(DoubleSeq s, int period, FastMatrix regs) {
        this.outliers = null;
        FastOutliersDetector impl = this.make(s);
        SarimaOrders spec = SarimaOrders.airline((int)period);
        SarimaModel airline = SarimaModel.builder(spec).setDefault().build();
        RegArimaModel<SarimaModel> regarima = RegArimaModel.builder().arima(airline).y(s).addX(regs).build();
        boolean ok = impl.process(regarima, SarimaMapping.of(spec));
        if (!ok) {
            return s;
        }
        this.outliers = impl.getOutliers();
        RegArimaModel<SarimaModel> regArima = impl.getRegArima();
        RegArimaEstimation<SarimaModel> estimation = RegArimaUtility.processor(true, this.eps).process(regArima, SarimaMapping.of(spec));
        return estimation.linearizedSeries();
    }

    public int[][] getOutliers() {
        return this.outliers;
    }

    public static class Builder {
        private double eps = 1.0E-5;
        private int maxOutliers = DEF_MAXOUTLIERS;
        private int maxRound = DEF_MAXROUND;
        private double cv = 6.0;

        private Builder() {
        }

        public Builder precision(double eps) {
            this.eps = eps;
            return this;
        }

        public Builder criticalValue(double cv) {
            this.cv = cv;
            return this;
        }

        public Builder maxOutliers(int max) {
            this.maxOutliers = max;
            return this;
        }

        public Builder maxRound(int max) {
            this.maxRound = max;
            return this;
        }

        public RobustOutliersDetector build() {
            return new RobustOutliersDetector(this);
        }
    }
}

