/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import jdplus.toolkit.base.core.regarima.RegArimaEstimation;
import jdplus.toolkit.base.core.regsarima.regular.IModelEstimator;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.tramoseats.base.core.tramo.TramoContext;

abstract class ModelController {
    private IModelEstimator estimator;
    private RegSarimaModelling refmodelling;

    ModelController() {
    }

    RegSarimaModelling getReferenceModel() {
        return this.refmodelling;
    }

    void setReferenceModel(RegSarimaModelling model) {
        this.refmodelling = model;
    }

    IModelEstimator getEstimator() {
        return this.estimator;
    }

    void setEstimator(IModelEstimator estimator) {
        this.estimator = estimator;
    }

    abstract ProcessingResult process(RegSarimaModelling var1, TramoContext var2);

    protected boolean checkMean(RegSarimaModelling context) {
        ModelDescription desc = context.getDescription();
        RegArimaEstimation estimation = context.getEstimation();
        if (!desc.isMean()) {
            return true;
        }
        int nhp = desc.getArimaSpec().freeParametersCount();
        double ser = estimation.getConcentratedLikelihood().ser(0, nhp, true);
        return Math.abs(estimation.getConcentratedLikelihood().coefficient(0) / ser) >= 1.96;
    }

    protected boolean estimate(RegSarimaModelling context, boolean checkmean) {
        if (!this.estimator.estimate(context)) {
            return false;
        }
        if (checkmean && !this.checkMean(context)) {
            context.getDescription().setMean(false);
            if (!this.estimator.estimate(context)) {
                return false;
            }
        }
        return true;
    }

    protected void transferInformation(RegSarimaModelling from, RegSarimaModelling to) {
        to.set(from.getDescription(), from.getEstimation());
    }
}

