/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramoseats.extractors;

import java.util.ArrayList;
import jdplus.sa.base.api.ComponentType;
import jdplus.sa.base.api.DecompositionMode;
import jdplus.sa.base.api.SaVariable;
import jdplus.sa.base.api.SeriesDecomposition;
import jdplus.sa.base.core.SaBenchmarkingResults;
import jdplus.toolkit.base.api.dictionaries.Dictionary;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.api.modelling.ComponentInformation;
import jdplus.toolkit.base.api.processing.ProcDiagnostic;
import jdplus.toolkit.base.api.processing.ProcQuality;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.api.util.IntList;
import jdplus.toolkit.base.core.modelling.GeneralLinearModel;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import jdplus.tramoseats.base.core.seats.SeatsResults;
import jdplus.tramoseats.base.core.tramoseats.TramoSeatsDiagnostics;
import jdplus.tramoseats.base.core.tramoseats.TramoSeatsFactory;
import jdplus.tramoseats.base.core.tramoseats.TramoSeatsResults;

public class TramoSeatsExtractor
extends InformationMapping<TramoSeatsResults> {
    public static final String FINAL = "";

    private String advancedItem(String key) {
        return Dictionary.concatenate((String[])new String[]{"regression.details", key});
    }

    private String qualityItem(String key) {
        return Dictionary.concatenate((String[])new String[]{"quality", key});
    }

    private TsData finalSeries(TramoSeatsResults source, ComponentType type, ComponentInformation info) {
        SeriesDecomposition finals = source.getFinals();
        if (finals == null) {
            return null;
        }
        return finals.getSeries(type, info);
    }

    public TramoSeatsExtractor() {
        this.set("mode", DecompositionMode.class, source -> source.getFinals() == null ? null : source.getFinals().getMode());
        this.set("seasonal", Integer.class, source -> {
            if (source.getDecomposition() == null) {
                return null;
            }
            TsData s = source.getDecomposition().getInitialComponents().getSeries(ComponentType.Seasonal, ComponentInformation.Value);
            if (s == null) {
                return 0;
            }
            return s.getValues().allMatch(x -> x == 0.0) ? 0 : 1;
        });
        this.set("y", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.Series, ComponentInformation.Value));
        this.set("y_b", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.Series, ComponentInformation.Backcast));
        this.set("y_f", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.Series, ComponentInformation.Forecast));
        this.set("t", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.Trend, ComponentInformation.Value));
        this.set("t_f", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.Trend, ComponentInformation.Forecast));
        this.set("t_ef", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.Trend, ComponentInformation.StdevForecast));
        this.set("t_b", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.Trend, ComponentInformation.Backcast));
        this.set("t_eb", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.Trend, ComponentInformation.StdevBackcast));
        this.set("sa", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.SeasonallyAdjusted, ComponentInformation.Value));
        this.set("sa_f", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast));
        this.set("sa_ef", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.SeasonallyAdjusted, ComponentInformation.StdevForecast));
        this.set("sa_b", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.SeasonallyAdjusted, ComponentInformation.Backcast));
        this.set("sa_eb", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.SeasonallyAdjusted, ComponentInformation.StdevBackcast));
        this.set("s", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.Seasonal, ComponentInformation.Value));
        this.set("s_f", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.Seasonal, ComponentInformation.Forecast));
        this.set("s_ef", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.Seasonal, ComponentInformation.StdevForecast));
        this.set("s_b", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.Seasonal, ComponentInformation.Backcast));
        this.set("s_eb", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.Seasonal, ComponentInformation.StdevBackcast));
        this.set("i", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.Irregular, ComponentInformation.Value));
        this.set("i_f", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.Irregular, ComponentInformation.Forecast));
        this.set("i_ef", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.Irregular, ComponentInformation.StdevForecast));
        this.set("i_b", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.Irregular, ComponentInformation.Backcast));
        this.set("i_eb", TsData.class, source -> this.finalSeries((TramoSeatsResults)source, ComponentType.Irregular, ComponentInformation.StdevBackcast));
        this.set(this.advancedItem("type"), int[].class, source -> {
            if (source.getPreprocessing() == null) {
                return null;
            }
            GeneralLinearModel.Description desc = source.getPreprocessing().getDescription();
            Variable[] vars = desc.getVariables();
            IntList list = new IntList();
            for (int i = 0; i < vars.length; ++i) {
                int n = vars[i].freeCoefficientsCount();
                if (n <= 0) continue;
                ComponentType regressionEffect = SaVariable.regressionEffect((Variable)vars[i]);
                for (int j = 0; j < n; ++j) {
                    list.add(regressionEffect.toInt());
                }
            }
            return list.toArray();
        });
        this.delegate("decomposition", SeatsResults.class, source -> source.getDecomposition());
        this.delegate(null, RegSarimaModel.class, source -> source.getPreprocessing());
        this.delegate(null, TramoSeatsDiagnostics.class, source -> source.getDiagnostics());
        this.set(this.qualityItem("summary"), String.class, source -> {
            ArrayList tests = new ArrayList();
            ArrayList warnings = new ArrayList();
            TramoSeatsFactory.getInstance().fillDiagnostics(tests, warnings, (Explorable)source);
            ProcQuality quality = ProcDiagnostic.summary(tests);
            return quality.name();
        });
        this.delegate("benchmarking", SaBenchmarkingResults.class, source -> source.getBenchmarking());
    }

    public Class<TramoSeatsResults> getSourceClass() {
        return TramoSeatsResults.class;
    }
}

