/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data.discretization;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Set;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DataView;
import org.vikamine.kernel.data.IDataRecordSet;
import org.vikamine.kernel.data.NumericAttribute;
import org.vikamine.kernel.data.discretization.AbstractDiscretizationMethod;
import org.vikamine.kernel.data.discretization.DiscretizationUtils;

public class KMeansDiscretizer
extends AbstractDiscretizationMethod {
    private static final int DEF_TRIES = 50;
    private static final int DEF_SAMPLESIZE = 10000;
    private static final String NAME = "K-Means Discretizer";
    private static final String SEGCOUNT = "segcount";
    private static final String TRIES = "tries";
    private static final String SAMPLESIZE = "samplesize";
    private double[] minmax;
    private int tries = 50;
    private int sampleSize = 10000;

    public KMeansDiscretizer() {
    }

    public KMeansDiscretizer(DataView population, NumericAttribute na, int segCount) {
        this.setPopulation(population);
        this.setAttribute(na);
        this.setSegmentsCount(segCount);
    }

    public KMeansDiscretizer(String[] args) {
        this();
        int i = 1;
        while (i < args.length) {
            String[] arg = args[i].split("=");
            if (arg[0].contains(SEGCOUNT)) {
                this.segmentsCount = Integer.parseInt(arg[1].trim());
            } else if (arg[0].contains(TRIES)) {
                this.tries = Integer.parseInt(arg[1].trim());
            } else if (arg[0].contains(SAMPLESIZE)) {
                this.sampleSize = Integer.parseInt(arg[1].trim());
            }
            ++i;
        }
    }

    private Clustering kMeansClustering(List<DataRecord> records) {
        Clustering clustering = new Clustering(records);
        Clustering oldClustering = null;
        while (!clustering.equals(oldClustering)) {
            oldClustering = clustering;
            clustering = new Clustering(oldClustering, records);
        }
        return clustering;
    }

    @Override
    public List<Double> getCutpoints() {
        if (this.population == null || this.attribute == null || this.population.dataset().getIndex(this.attribute) < 0 || this.population.size() < this.segmentsCount) {
            return new ArrayList<Double>();
        }
        if (this.minmax == null) {
            this.minmax = DiscretizationUtils.getMinMaxValue(this.population, this.attribute);
        }
        List<DataRecord> records = this.population.size() > this.sampleSize ? new SampleList(DiscretizationUtils.resample(this.population.dataset(), this.population.size(), this.sampleSize)) : new PopulationList();
        this.sortedSample = DiscretizationUtils.getSortedDataRecords(records, this.attribute, false, false);
        Clustering clustering = this.kMeansClustering(records);
        BigDecimal smallestCubes = clustering.cubedDistances();
        int i = 1;
        while (i < this.tries) {
            Clustering test = this.kMeansClustering(records);
            BigDecimal testCubes = test.cubedDistances();
            if (testCubes.compareTo(smallestCubes) == -1) {
                clustering = test;
                smallestCubes = testCubes;
            }
            ++i;
        }
        return clustering.toList();
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static final class Cluster
    extends ArrayList<Double>
    implements Comparable<Cluster> {
        private final double center;
        private double minVal = Double.MAX_VALUE;
        private double maxVal = Double.MIN_VALUE;

        private Cluster(double center) {
            this.center = center;
        }

        private Cluster(Cluster cluster) {
            this.center = cluster.computeCenter();
        }

        private void add(double val) {
            if (val < this.minVal) {
                this.minVal = val;
            }
            if (val > this.maxVal) {
                this.maxVal = val;
            }
            super.add(val);
        }

        private double computeCenter() {
            if (this.size() == 0) {
                return 0.0;
            }
            Iterator iterator = this.iterator();
            BigDecimal center = new BigDecimal(0);
            while (iterator.hasNext()) {
                center = center.add(new BigDecimal((Double)iterator.next()));
            }
            return center.divide(new BigDecimal(this.size()), MathContext.DECIMAL128).doubleValue();
        }

        private double distanceTo(double val) {
            return Math.abs(this.center - val);
        }

        @Override
        public int compareTo(Cluster o) {
            return this.maxVal < o.minVal ? -1 : (this.minVal > o.maxVal ? 1 : 0);
        }

        private BigDecimal cubedDistances() {
            BigDecimal result = BigDecimal.ZERO;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                result = result.add(new BigDecimal(Math.pow(Math.abs((Double)it.next() - this.center), 2.0)));
            }
            return result;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Cluster other = (Cluster)obj;
            return Double.doubleToLongBits(this.center) == Double.doubleToLongBits(other.center);
        }
    }

    private final class Clustering {
        private final Cluster[] cluster;

        private Clustering(List<DataRecord> records) {
            this.cluster = new Cluster[KMeansDiscretizer.this.segmentsCount];
            Random random = new Random();
            int size = records.size();
            int i = 0;
            while (i < KMeansDiscretizer.this.segmentsCount) {
                this.cluster[i] = new Cluster(records.get(random.nextInt(size)).getValue(KMeansDiscretizer.this.attribute));
                ++i;
            }
            this.populate(records.iterator());
        }

        private Clustering(Clustering oldClustering, List<DataRecord> records) {
            this.cluster = new Cluster[KMeansDiscretizer.this.segmentsCount];
            int i = 0;
            while (i < KMeansDiscretizer.this.segmentsCount) {
                this.cluster[i] = new Cluster(oldClustering.cluster[i]);
                ++i;
            }
            this.populate(records.iterator());
        }

        private void populate(Iterator<DataRecord> recordIterator) {
            while (recordIterator.hasNext()) {
                double val = recordIterator.next().getValue(KMeansDiscretizer.this.attribute);
                if (Double.isNaN(val)) continue;
                Cluster closest = this.cluster[0];
                double minDist = closest.distanceTo(val);
                int i = 1;
                while (i < KMeansDiscretizer.this.segmentsCount) {
                    double dist = this.cluster[i].distanceTo(val);
                    if (dist < minDist) {
                        minDist = dist;
                        closest = this.cluster[i];
                    }
                    ++i;
                }
                closest.add(val);
            }
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            Clustering other = (Clustering)obj;
            int i = 0;
            while (i < this.cluster.length) {
                if (!this.cluster[i].equals(other.cluster[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public int hashCode() {
            return super.hashCode();
        }

        private List<Double> toList() {
            ArrayList<Double> list = new ArrayList<Double>();
            Arrays.sort(this.cluster);
            int i = 1;
            while (i < KMeansDiscretizer.this.segmentsCount && this.cluster[i].size() > 0) {
                list.add((this.cluster[i - 1].maxVal + this.cluster[i].minVal) / 2.0);
                ++i;
            }
            return list;
        }

        private BigDecimal cubedDistances() {
            BigDecimal result = BigDecimal.ZERO;
            int i = 0;
            while (i < KMeansDiscretizer.this.segmentsCount) {
                result = result.add(this.cluster[i].cubedDistances());
                ++i;
            }
            return result;
        }
    }

    private final class PopulationList
    implements List<DataRecord> {
        IDataRecordSet set;

        private PopulationList() {
            this.set = KMeansDiscretizer.this.population.dataset();
        }

        @Override
        public boolean add(DataRecord arg0) {
            return false;
        }

        @Override
        public void add(int arg0, DataRecord arg1) {
        }

        @Override
        public boolean addAll(Collection<? extends DataRecord> arg0) {
            return false;
        }

        @Override
        public boolean addAll(int arg0, Collection<? extends DataRecord> arg1) {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean contains(Object arg0) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> arg0) {
            return false;
        }

        @Override
        public DataRecord get(int arg0) {
            return this.set.get(arg0);
        }

        @Override
        public int indexOf(Object arg0) {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<DataRecord> iterator() {
            return KMeansDiscretizer.this.population.iterator();
        }

        @Override
        public int lastIndexOf(Object arg0) {
            return 0;
        }

        @Override
        public ListIterator<DataRecord> listIterator() {
            return null;
        }

        @Override
        public ListIterator<DataRecord> listIterator(int arg0) {
            return null;
        }

        @Override
        public boolean remove(Object arg0) {
            return false;
        }

        @Override
        public DataRecord remove(int arg0) {
            return null;
        }

        @Override
        public boolean removeAll(Collection<?> arg0) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> arg0) {
            return false;
        }

        @Override
        public DataRecord set(int arg0, DataRecord arg1) {
            return null;
        }

        @Override
        public int size() {
            return KMeansDiscretizer.this.population.size();
        }

        @Override
        public List<DataRecord> subList(int arg0, int arg1) {
            return null;
        }

        @Override
        public Object[] toArray() {
            return null;
        }

        @Override
        public <T> T[] toArray(T[] arg0) {
            return null;
        }
    }

    private static final class SampleList
    implements List<DataRecord> {
        private final DataRecord[] set;
        private final Set<DataRecord> sample;

        public SampleList(Set<DataRecord> resample) {
            this.set = resample.toArray(new DataRecord[resample.size()]);
            this.sample = resample;
        }

        @Override
        public boolean add(DataRecord arg0) {
            return false;
        }

        @Override
        public void add(int arg0, DataRecord arg1) {
        }

        @Override
        public boolean addAll(Collection<? extends DataRecord> arg0) {
            return false;
        }

        @Override
        public boolean addAll(int arg0, Collection<? extends DataRecord> arg1) {
            return false;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean contains(Object arg0) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> arg0) {
            return false;
        }

        @Override
        public DataRecord get(int arg0) {
            return this.set[arg0];
        }

        @Override
        public int indexOf(Object arg0) {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<DataRecord> iterator() {
            return this.sample.iterator();
        }

        @Override
        public int lastIndexOf(Object arg0) {
            return 0;
        }

        @Override
        public ListIterator<DataRecord> listIterator() {
            return null;
        }

        @Override
        public ListIterator<DataRecord> listIterator(int arg0) {
            return null;
        }

        @Override
        public boolean remove(Object arg0) {
            return false;
        }

        @Override
        public DataRecord remove(int arg0) {
            return null;
        }

        @Override
        public boolean removeAll(Collection<?> arg0) {
            return false;
        }

        @Override
        public boolean retainAll(Collection<?> arg0) {
            return false;
        }

        @Override
        public DataRecord set(int arg0, DataRecord arg1) {
            return null;
        }

        @Override
        public int size() {
            return this.sample.size();
        }

        @Override
        public List<DataRecord> subList(int arg0, int arg1) {
            return null;
        }

        @Override
        public Object[] toArray() {
            return null;
        }

        @Override
        public <T> T[] toArray(T[] arg0) {
            return null;
        }
    }
}

