/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evolution.coalescent.TreeIntervalList;
import dr.evomodel.coalescent.GMRFSkyrideLikelihood;
import dr.inference.model.DesignMatrix;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import no.uib.cipr.matrix.SymmTridiagMatrix;

public class GMRFTestLikelihood
extends GMRFSkyrideLikelihood {
    private Parameter intervalsParameter;
    private Parameter statsParameter;
    private Parameter betaParameter;

    public GMRFTestLikelihood(TreeIntervalList treeIntervalList, Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, DesignMatrix designMatrix) {
        super(treeIntervalList, parameter, null, parameter2, parameter3, parameter4, (MatrixParameter)designMatrix, false, true);
    }

    public GMRFTestLikelihood(Parameter parameter, Parameter parameter2, Parameter parameter3, Parameter parameter4, DesignMatrix designMatrix, Parameter parameter5, Parameter parameter6) {
        this.popSizeParameter = parameter;
        this.precisionParameter = parameter2;
        this.lambdaParameter = parameter3;
        this.intervalsParameter = parameter5;
        this.statsParameter = parameter6;
        this.betaParameter = parameter4;
        this.fieldLength = this.popSizeParameter.getDimension();
        this.addVariable(this.popSizeParameter);
        this.addVariable(this.precisionParameter);
        this.addVariable(this.lambdaParameter);
        this.addVariable(this.intervalsParameter);
        this.addVariable(this.statsParameter);
        this.addVariable(this.betaParameter);
        this.setupGMRFWeights();
    }

    @Override
    protected void storeState() {
        super.storeState();
        System.arraycopy(this.coalescentIntervals, 0, this.storedCoalescentIntervals, 0, this.coalescentIntervals.length);
        System.arraycopy(this.sufficientStatistics, 0, this.storedSufficientStatistics, 0, this.sufficientStatistics.length);
        this.storedWeightMatrix = this.weightMatrix.copy();
    }

    @Override
    protected void restoreState() {
        super.restoreState();
        double[] dArray = this.coalescentIntervals;
        this.coalescentIntervals = this.storedCoalescentIntervals;
        this.storedCoalescentIntervals = dArray;
        dArray = this.sufficientStatistics;
        this.sufficientStatistics = this.storedSufficientStatistics;
        this.storedSufficientStatistics = dArray;
        this.weightMatrix = this.storedWeightMatrix;
    }

    @Override
    public double calculateLogLikelihood() {
        return 0.0;
    }

    @Override
    protected void setupGMRFWeights() {
        int n;
        this.coalescentIntervals = this.intervalsParameter.getParameterValues();
        this.sufficientStatistics = this.statsParameter.getParameterValues();
        this.storedCoalescentIntervals = new double[this.coalescentIntervals.length];
        this.storedSufficientStatistics = new double[this.sufficientStatistics.length];
        double[] dArray = new double[this.fieldLength - 1];
        double[] dArray2 = new double[this.fieldLength];
        for (n = 0; n < this.fieldLength - 1; ++n) {
            dArray[n] = -2.0 / (this.coalescentIntervals[n] + this.coalescentIntervals[n + 1]);
        }
        for (n = 1; n < this.fieldLength - 1; ++n) {
            dArray2[n] = -(dArray[n] + dArray[n - 1]);
        }
        dArray2[0] = -dArray[0];
        dArray2[this.fieldLength - 1] = -dArray[this.fieldLength - 2];
        this.weightMatrix = new SymmTridiagMatrix(dArray2, dArray);
    }
}

