/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.coalescent;

import dr.evomodel.bigfasttree.BigFastTreeIntervals;
import dr.evomodel.coalescent.SingleTreeTimeline;

public class SingleTreeNodesTimeline
extends SingleTreeTimeline {
    private final int nNodes = this.getnNodes();
    private final double[] timeLine = new double[this.nNodes];
    private final boolean[] flagCoalescentEvent;
    private int[] numLineages = new int[this.nNodes];

    public SingleTreeNodesTimeline(BigFastTreeIntervals bigFastTreeIntervals) {
        super(bigFastTreeIntervals);
        this.flagCoalescentEvent = new boolean[this.nNodes];
        this.makeLine();
    }

    protected void makeLine() {
        this.timeLine[0] = this.treeIntervals.getStartTime();
        this.flagCoalescentEvent[0] = false;
        for (int i = 1; i < this.nNodes; ++i) {
            this.timeLine[i] = this.treeIntervals.getIntervalTime(i);
            this.numLineages[i] = this.treeIntervals.getLineageCount(i);
            this.flagCoalescentEvent[i] = String.valueOf((Object)this.treeIntervals.getIntervalType(i - 1)).equals("coalescent");
        }
    }

    @Override
    protected int getnNodes() {
        return this.nNodes;
    }

    protected boolean[] getFlagCoalescentEvent() {
        return this.flagCoalescentEvent;
    }

    protected double[] getTimeLine() {
        return this.timeLine;
    }
}

