/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.MathUtils;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DiffusionModel
extends AbstractModel {
    public static final String DIFFUSION_PROCESS = "diffusionProcess";
    public static final String DIFFUSION_CONSTANT = "D";
    public static final String BIAS = "mu";
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule("D", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), new ElementRule("mu", new XMLSyntaxRule[]{new ElementRule(Parameter.class)})};

        @Override
        public String getParserName() {
            return DiffusionModel.DIFFUSION_PROCESS;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            XMLObject xMLObject2 = xMLObject.getChild(DiffusionModel.DIFFUSION_CONSTANT);
            Parameter parameter = (Parameter)xMLObject2.getChild(Parameter.class);
            Parameter parameter2 = null;
            if (xMLObject.hasAttribute(DiffusionModel.BIAS)) {
                xMLObject2 = xMLObject.getChild(DiffusionModel.BIAS);
                parameter2 = (Parameter)xMLObject2.getChild(Parameter.class);
            }
            if (parameter2 == null) {
                return new DiffusionModel(parameter);
            }
            return new DiffusionModel(parameter, parameter2);
        }

        @Override
        public String getParserDescription() {
            return "Describes a diffusion process.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return DiffusionModel.class;
        }
    };
    private final Parameter diffusionRateParameter;
    private Parameter biasParameter;

    public DiffusionModel(Parameter parameter) {
        super(DIFFUSION_PROCESS);
        this.diffusionRateParameter = parameter;
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
    }

    public DiffusionModel(Parameter parameter, Parameter parameter2) {
        super(DIFFUSION_PROCESS);
        this.diffusionRateParameter = parameter;
        this.biasParameter = parameter2;
        this.addVariable(parameter);
        this.addVariable(parameter2);
        parameter.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
    }

    public double getD() {
        return this.diffusionRateParameter.getParameterValue(0);
    }

    public double getLogLikelihood(double d, double d2, double d3) {
        double d4 = this.diffusionRateParameter.getParameterValue(0);
        double d5 = this.getBias();
        double d6 = d4 * d3;
        double d7 = d2 - d - d5 * d3;
        return -0.5 * Math.log(d6) - d7 * d7 / d6;
    }

    public double simulateForward(double d, double d2) {
        double d3 = this.diffusionRateParameter.getParameterValue(0);
        double d4 = MathUtils.nextGaussian();
        d4 *= Math.sqrt(d3 * d2);
        return d + (d4 += this.getBias() * d2);
    }

    private double getBias() {
        if (this.biasParameter == null) {
            return 0.0;
        }
        return this.biasParameter.getParameterValue(0);
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    public void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }
}

