/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractDenseMatrix;
import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Interface;
import no.uib.cipr.matrix.LowerSPDDenseMatrix;
import no.uib.cipr.matrix.LowerTriangDenseMatrix;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.UpperSPDDenseMatrix;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;

public class DenseCholesky {
    private final int n;
    private LowerTriangDenseMatrix Cl;
    private UpperTriangDenseMatrix Cu;
    private boolean notspd;
    private final boolean upper;

    public DenseCholesky(int n, boolean upper) {
        this.n = n;
        this.upper = upper;
        if (upper) {
            this.Cu = new UpperTriangDenseMatrix(n);
        } else {
            this.Cl = new LowerTriangDenseMatrix(n);
        }
    }

    public static DenseCholesky factorize(Matrix A) {
        return new DenseCholesky(A.numRows(), true).factor(new UpperSPDDenseMatrix(A));
    }

    public DenseCholesky factor(LowerSPDDenseMatrix A) {
        if (this.upper) {
            throw new IllegalArgumentException("Cholesky decomposition constructed for upper matrices");
        }
        return this.decompose(A);
    }

    public DenseCholesky factor(UpperSPDDenseMatrix A) {
        if (!this.upper) {
            throw new IllegalArgumentException("Cholesky decomposition constructed for lower matrices");
        }
        return this.decompose(A);
    }

    private DenseCholesky decompose(AbstractDenseMatrix A) {
        if (this.n != A.numRows()) {
            throw new IllegalArgumentException("n != A.numRows()");
        }
        this.notspd = false;
        int info = 0;
        info = this.upper ? Interface.lapack().potrf(BLASkernel.UpLo.Upper, A.numRows(), A.getData()) : Interface.lapack().potrf(BLASkernel.UpLo.Lower, A.numRows(), A.getData());
        if (info > 0) {
            this.notspd = true;
        } else if (info < 0) {
            throw new IllegalArgumentException();
        }
        if (this.upper) {
            this.Cu.set(A);
        } else {
            this.Cl.set(A);
        }
        return this;
    }

    public boolean isSPD() {
        return !this.notspd;
    }

    public LowerTriangDenseMatrix getL() {
        if (!this.upper) {
            return this.Cl;
        }
        throw new UnsupportedOperationException();
    }

    public UpperTriangDenseMatrix getU() {
        if (this.upper) {
            return this.Cu;
        }
        throw new UnsupportedOperationException();
    }

    public DenseMatrix solve(DenseMatrix B) throws MatrixNotSPDException {
        if (this.notspd) {
            throw new MatrixNotSPDException();
        }
        if (this.n != B.numRows()) {
            throw new IllegalArgumentException("n != B.numRows()");
        }
        int info = 0;
        info = this.upper ? Interface.lapack().potrs(BLASkernel.UpLo.Upper, this.Cu.numRows(), B.numColumns(), this.Cu.getData(), B.getData()) : Interface.lapack().potrs(BLASkernel.UpLo.Lower, this.Cl.numRows(), B.numColumns(), this.Cl.getData(), B.getData());
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return B;
    }

    public double rcond(Matrix A) {
        if (this.n != A.numRows()) {
            throw new IllegalArgumentException("n != A.numRows()");
        }
        if (!A.isSquare()) {
            throw new IllegalArgumentException("!A.isSquare()");
        }
        double anorm = A.norm(Matrix.Norm.One);
        double[] work = new double[3 * this.n];
        int[] iwork = new int[this.n];
        double[] rcond = new double[1];
        int info = 0;
        info = this.upper ? Interface.lapack().pocon(BLASkernel.UpLo.Upper, this.n, this.Cu.getData(), anorm, rcond, work, iwork) : Interface.lapack().pocon(BLASkernel.UpLo.Lower, this.n, this.Cl.getData(), anorm, rcond, work, iwork);
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return rcond[0];
    }
}

