/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.sqlengine.parser;

import com.amazon.sqlengine.parser.parsetree.IPTNode;
import com.amazon.sqlengine.parser.parsetree.PTDefaultParameterNode;
import com.amazon.sqlengine.parser.parsetree.PTDynamicParameterNode;
import com.amazon.sqlengine.parser.parsetree.PTEmptyNode;
import com.amazon.sqlengine.parser.parsetree.PTFlagNode;
import com.amazon.sqlengine.parser.parsetree.PTIdentifierNode;
import com.amazon.sqlengine.parser.parsetree.PTListNode;
import com.amazon.sqlengine.parser.parsetree.PTLiteralNode;
import com.amazon.sqlengine.parser.parsetree.PTNonterminalNode;
import com.amazon.sqlengine.parser.type.PTFlagType;
import com.amazon.sqlengine.parser.type.PTListType;
import com.amazon.sqlengine.parser.type.PTLiteralType;
import com.amazon.sqlengine.parser.type.PTNonterminalType;
import com.amazon.sqlengine.parser.type.PTPositionalType;
import com.amazon.support.exceptions.ErrorException;
import java.util.Arrays;
import java.util.List;

public class PTNodeFactory {
    private static final PTEmptyNode EMPTY_NODE = new PTEmptyNode();
    private static final PTDefaultParameterNode DEFAULT_PARAM_NODE = new PTDefaultParameterNode();
    private static final PTFlagNode[] FLAG_CACHE;
    private int m_parameterCount = 0;

    public PTDefaultParameterNode buildDefaultParameterNode() {
        return DEFAULT_PARAM_NODE;
    }

    public PTDynamicParameterNode buildDynamicParameterNode() {
        return new PTDynamicParameterNode(this.nextParameterIndex());
    }

    public PTEmptyNode buildEmptyNode() {
        return EMPTY_NODE;
    }

    public PTFlagNode buildFlagNode(PTFlagType pTFlagType) {
        assert (null != pTFlagType);
        assert (pTFlagType.ordinal() < FLAG_CACHE.length);
        return FLAG_CACHE[pTFlagType.ordinal()];
    }

    public PTIdentifierNode buildIdentifierNode(String string) {
        return new PTIdentifierNode(string);
    }

    public PTListNode buildListNode(PTListType pTListType, IPTNode ... iPTNodeArray) {
        return this.buildListNode(pTListType, Arrays.asList(iPTNodeArray));
    }

    public PTListNode buildListNode(PTListType pTListType, List<IPTNode> list) {
        if (null == pTListType) {
            throw new NullPointerException("listType must not be null");
        }
        if (null == list) {
            throw new NullPointerException("children must not be null");
        }
        PTListNode pTListNode = new PTListNode(pTListType);
        for (IPTNode iPTNode : list) {
            if (null == iPTNode) {
                throw new NullPointerException("Child node must not be null");
            }
            pTListNode.addChild(iPTNode);
        }
        return pTListNode;
    }

    public PTLiteralNode buildLiteralNode(PTLiteralType pTLiteralType, String string) {
        if (null == pTLiteralType || null == string) {
            throw new NullPointerException();
        }
        return new PTLiteralNode(pTLiteralType, string);
    }

    public PTNonterminalNode buildNonterminalNode(PTNonterminalType pTNonterminalType) {
        if (null == pTNonterminalType) {
            throw new NullPointerException("ntType must not be null");
        }
        return new PTNonterminalNode(pTNonterminalType);
    }

    public PTNonterminalNode buildNonterminalNode(PTNonterminalType pTNonterminalType, Object ... objectArray) {
        if (0 != objectArray.length % 2) {
            throw new IllegalArgumentException("Missing value for key");
        }
        PTNonterminalNode pTNonterminalNode = new PTNonterminalNode(pTNonterminalType);
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            Object object2 = objectArray[i + 1];
            if (!(object instanceof PTPositionalType) || !(object2 instanceof IPTNode)) {
                throw new IllegalArgumentException("Invalid key or value: " + object + ", " + object2);
            }
            try {
                pTNonterminalNode.addChild((PTPositionalType)((Object)object), (IPTNode)object2);
                continue;
            }
            catch (ErrorException errorException) {
                throw new RuntimeException("Logic error", errorException);
            }
        }
        return pTNonterminalNode;
    }

    private int nextParameterIndex() {
        return ++this.m_parameterCount;
    }

    static {
        PTFlagType[] pTFlagTypeArray = PTFlagType.values();
        FLAG_CACHE = new PTFlagNode[pTFlagTypeArray.length];
        for (int i = 0; i < pTFlagTypeArray.length; ++i) {
            PTNodeFactory.FLAG_CACHE[i] = new PTFlagNode(pTFlagTypeArray[i]);
        }
    }
}

