/*
 * Decompiled with CFR 0.152.
 */
package javalain.math.fonction.simpleobjectif;

import java.util.Comparator;
import javalain.ea.SolutionEA;
import javalain.ea.operator.comparator.ObjectiveComparator;
import javalain.math.fonction.Fct;

public final class Ellipsoide
extends Fct {
    public Ellipsoide() {
        this(10);
    }

    public Ellipsoide(int d) {
        this.nomFct = "Ellipso\u00efde";
        this.nbVariable = d;
        this.nbFctObjectif = 1;
        this.lowerLimit = new double[this.nbVariable];
        this.upperLimit = new double[this.nbVariable];
        for (int i = 0; i < this.nbVariable; ++i) {
            this.lowerLimit[i] = -5.12;
            this.upperLimit[i] = 5.12;
        }
    }

    @Override
    public double[] compute(double[] x) {
        ++this.nbEvaluation;
        double[] fct = new double[this.nbFctObjectif];
        fct[0] = 0.0;
        for (int i = 0; i < this.nbVariable; ++i) {
            fct[0] = fct[0] + (double)(i + 1) * x[i] * x[i];
        }
        return fct;
    }

    @Override
    public double[][] getFront() {
        if (this.front == null) {
            this.front = new double[1][this.nbVariable];
            for (int i = 0; i < this.nbVariable; ++i) {
                this.front[0][i] = 0.0;
            }
        }
        return this.front;
    }

    @Override
    public Comparator<SolutionEA> comparator() {
        return new ObjectiveComparator(0);
    }
}

