/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v20;

import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.SDMXReference;
import it.bancaditalia.oss.sdmx.client.Parser;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.LocalizedText;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class DataflowParser
implements Parser<List<Dataflow>> {
    protected static Logger logger = Configuration.getSdmxLogger();
    private static final String DATAFLOW = "Dataflow";
    private static final String ID = "id";
    private static final String AGENCY = "agencyID";
    private static final String VERSION = "version";
    private static final String NAME = "Name";
    private static final String KF_REF = "KeyFamilyRef";
    private static final String KF_ID = "KeyFamilyID";
    private static final String KF_AGID = "KeyFamilyAgencyID";
    private static final String KF_VER = "Version";

    @Override
    public List<Dataflow> parse(XMLEventReader xMLEventReader, List<Locale.LanguageRange> list) throws XMLStreamException, SdmxException {
        ArrayList<Dataflow> arrayList = new ArrayList<Dataflow>();
        Dataflow dataflow = null;
        LocalizedText localizedText = new LocalizedText(list);
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                StartElement startElement = xMLEvent.asStartElement();
                if (startElement.getName().getLocalPart() == DATAFLOW) {
                    localizedText = new LocalizedText(list);
                    String string = null;
                    String string2 = null;
                    String string3 = null;
                    for (Attribute attribute : startElement::getAttributes) {
                        switch (attribute.getName().toString()) {
                            case "id": {
                                string = attribute.getValue();
                                break;
                            }
                            case "agencyID": {
                                string2 = attribute.getValue();
                                break;
                            }
                            case "version": {
                                string3 = attribute.getValue();
                            }
                        }
                    }
                    dataflow = new Dataflow(string, string2, string3, localizedText);
                }
                if (startElement.getName().getLocalPart() == NAME) {
                    localizedText.setText(startElement, xMLEventReader);
                }
                if (startElement.getName().getLocalPart() != KF_REF) continue;
                DataflowParser.setKeyFamily(dataflow, xMLEventReader);
                continue;
            }
            if (!xMLEvent.isEndElement() || !DATAFLOW.equals(xMLEvent.asEndElement().getName().getLocalPart())) continue;
            arrayList.add(dataflow);
        }
        return arrayList;
    }

    private static void setKeyFamily(Dataflow dataflow, XMLEventReader xMLEventReader) throws XMLStreamException {
        String string = null;
        String string2 = null;
        String string3 = null;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent = xMLEventReader.nextEvent();
            logger.finest(xMLEvent.toString());
            if (xMLEvent.isStartElement()) {
                switch (xMLEvent.asStartElement().getName().getLocalPart()) {
                    case "KeyFamilyID": {
                        string = xMLEventReader.getElementText();
                        break;
                    }
                    case "KeyFamilyAgencyID": {
                        string2 = xMLEventReader.getElementText();
                        break;
                    }
                    case "Version": {
                        string3 = xMLEventReader.getElementText();
                    }
                }
                continue;
            }
            if (!xMLEvent.isEndElement() || xMLEvent.asEndElement().getName().getLocalPart() != KF_REF) continue;
            dataflow.setDsdIdentifier(new SDMXReference(string, string2, string3));
            break;
        }
    }
}

