## ----echo = FALSE, warning=FALSE----------------------------------------------
library(YEAB)

## -----------------------------------------------------------------------------
data("r_times")
r_times <- r_times[r_times < 60] # This example is a Peak trial, so we keep only the responses up to the FI value of 60s.

head(r_times, n = 30)

## -----------------------------------------------------------------------------
bp_from_opt <- bp_opt(r_times, 60)

print(bp_from_opt)

bp_from_exhaus <- exhaustive_sbp(r_times, 60)

print(bp_from_exhaus)

## ----echo= FALSE--------------------------------------------------------------
plot(r_times, seq_along(r_times),
  xlim = c(min(r_times), max(r_times)),
  xlab = "Time (s)",
  ylab = "Cummulative Response",
  col = 2, type = "l", lwd = 2,
)
abline(v = bp_from_opt$bp, lty = 3, lwd = 2)
legend(
  "topleft",
  legend = c("Breakpoint", "Response"),
  lty = c(3, 1), lwd = 2,
  col = c("black", "red"),
  cex = 1, bty = "n"
)

