## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup installation, eval=FALSE-------------------------------------------
# #install the stable CRAN release:
# #install.packages("avstrat") # this will only work once it is on CRAN
# 
# #install the development version from gitlab using the devtools package:
# devtools::install_gitlab("vsc/tephra/tools/avstrat",
#                         host = "code.usgs.gov",
#                         build_vignettes = TRUE)
# 
# # Other packages you'll want intstalled if you don't have them already
# install.packages("tidyverse")
# install.packages("readxl")

## ----setup--------------------------------------------------------------------
library(readxl)
library(ggplot2)
library(patchwork)
library(avstrat)

## -----------------------------------------------------------------------------
theme_set(theme_avstrat())

## ----include=FALSE------------------------------------------------------------
# Hidden, because this is just to find the packages files
# Locate the example Excel files shipped with the package
path_samples <- system.file("extdata", "example_samples_stations_upload_2024.xlsx",
                            package = "avstrat"
)
path_layers <- system.file("extdata", "example_layers_upload_2024.xlsx",
                           package = "avstrat"
)
path_indiv <- system.file("extdata", "example_inputs.xlsx",
                           package = "avstrat"
)

## ----copy-templates, eval=FALSE-----------------------------------------------
# file.copy(path_samples, "example_samples_stations_upload_2024.xlsx")
# file.copy(path_layers, "example_layers_upload_2024.xlsx")

## -----------------------------------------------------------------------------
station_sample_upload <- readxl::read_xlsx(path_samples, sheet = "Data")
layer_upload <- readxl::read_xlsx(path_layers, sheet = "Data")

## -----------------------------------------------------------------------------
mydata <- load_geodiva_forms(station_sample_upload = station_sample_upload,
                             layer_upload = layer_upload)

## ----copy-templates-indiv, eval=FALSE-----------------------------------------
# file.copy(path_indiv, "example_inputs.xlsx")

## -----------------------------------------------------------------------------
stations_data <- readxl::read_xlsx(path_indiv, sheet = "stations")
sections_data <- readxl::read_xlsx(path_indiv, sheet = "sections")
layers_data <- readxl::read_xlsx(path_indiv, sheet = "layers")
samples_data <- readxl::read_xlsx(path_indiv, sheet = "samples_layer")


mydata <- load_stratdata_indiv(
  stations_upload = stations_data,
  sections_upload = sections_data,
  layers_upload = layers_data,
  samples_upload = samples_data
)

## ----basic-plots, fig.width=9, fig.height=6-----------------------------------
grainsize_increasing <- ggstrat(df = mydata, 
                                section_name = "21LSHD02")
grainsize_decreasing <- ggstrat(df = mydata, 
                                section_name = "21LSHD02", 
                                grainsize_direction = "decreasing")
grainsize_column <- ggstrat_column(df = mydata, 
                                section_name = "21LSHD02")
# Combine all 3 plots using Patchwork
grainsize_increasing + grainsize_decreasing + grainsize_column

## ----zoomed-plot, fig.width=6, fig.height=6-----------------------------------
sample_label <- ggstrat_label(df = mydata, 
                                section_name = "21LSHD02")
grainsize_increasing + sample_label

## ----eval=FALSE---------------------------------------------------------------
# run_ggstrat_app(df = mydata)

## ----eval=FALSE---------------------------------------------------------------
# mystratplot <- function(df,
#                         section_name) {
#   ggstrat(df = df, section_name = {{ section_name }}) +
#     theme(plot.margin = unit(c(0.1, 0.1, 0.1, 0.1), "cm")) +
#   ggstrat_label(df = df, section_name = {{ section_name }},
#                                label = "SampleID") +
#     theme(plot.margin = unit(c(0.1, 1.5, 0.1, 0.1), "cm")) +
#   ggstrat_label(df = df, section_name = {{ section_name }},
#                                 label = "volcano_name") +
#     theme(plot.margin = unit(c(0.1, 0.5, 0.1, 0.1), "cm")) +
#     plot_layout(guides='collect') & theme(legend.position='bottom')
# }
# 
# run_ggstrat_app(df = mydata, plot = mystratplot)

## ----save-plot, eval=FALSE----------------------------------------------------
# ggsave(plot = grainsize_increasing,
#        filename = "mytestsection.png",
#        width = 3,
#        height = 6,
#        units = "in",
#        dpi = 300)

## ----bulk-save, eval=FALSE----------------------------------------------------
# ggstrat_bulk_save(df = mydata,
#                   plotfunction = ggstrat_samples,
#                   outdir = "StratSectionsPLotted",
#                   file_type = "png",
#                   width = 6,
#                   height = 6,
#                   units = "in")

