## ----include = FALSE----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::opts_chunk$set( #nolint
  collapse = TRUE,
  comment = "#>"
)
old <- options(width = 200L)

## ----error = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
base::message("This is another message")
loggit2::message("This is a message")

base::warning("This is another warning")
loggit2::warning("This is a warning")

base::stop("This is another error")
loggit2::stop("This is an error")

base::stopifnot("This is another condition" = FALSE)
loggit2::stopifnot("This is another condition" = FALSE)

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
loggit2::warning("This is a alternative warning", echo = FALSE)

loggit2::warning("This is not part of the log", .loggit = FALSE)

## ----echo = FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
loggit2::read_logs()
loggit2::rotate_logs(0L)

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
loggit2::loggit("INFO", "This is a message", ID = 1L, boole = TRUE)

loggit2::loggit("WARN", "This is a alternative warning", echo = FALSE)

loggit2::loggit("DEBUG", "This is a message", Why = "Because", echo = FALSE)

## ----error = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
loggit2::loggit("CRITICAL", "Critical error")

loggit2::loggit("CRITICAL", "Critical error 2", custom_log_lvl = TRUE)

## ----echo = FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
loggit2::read_logs()
loggit2::rotate_logs(0L)

## ----error = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
fun_a <- function(x) {
  base::warning("This is a warning")
  base::message("This is a message")
  base::stopifnot("This is true" = 3L == 1L + 2L, "This is not TRUE" = FALSE)
}

fun_b <- function(x) {
  base::warning("This is a second warning")
  5L + 5L
}

## ----error = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
x <- loggit2::with_loggit(fun_b())
print(x)

## ----error = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
loggit2::with_loggit({
  x <- fun_b()
  fun_a()
}, echo = FALSE)

## ----echo = FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
loggit2::read_logs()

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
loggit2::read_logs()

## ----eval = FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
#  loggit2::convert_to_csv("path/to/your/file.csv")

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
loggit2::rotate_logs(2L)

## ----echo = FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
loggit2::read_logs()

## -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
loggit2::rotate_logs(0L)

## ----echo = FALSE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
loggit2::read_logs()

## ----include = FALSE----------------------------------------------------------
options(old)

