## Test that request can be created
api <- hal_query()

## Default endpoint
expect_identical(
  odyssey:::hal_request(api)$url,
  "https://api.archives-ouvertes.fr/search?q=text%3A%2A&fl=docid%2Clabel_s&wt=json"
)

## Search in collection
expect_identical(
  odyssey:::hal_request(api, instance = "ARCHEOSCIENCES-BORDEAUX")$url,
  "https://api.archives-ouvertes.fr/search/ARCHEOSCIENCES-BORDEAUX?q=text%3A%2A&fl=docid%2Clabel_s&wt=json"
)

## Search in portal
expect_identical(
  odyssey:::hal_request(api, path = "ref", instance = "anrproject")$url,
  "https://api.archives-ouvertes.fr/ref/anrproject?q=text%3A%2A&fl=docid%2Clabel_s&wt=json"
)
