/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.charges;

import org.openscience.cdk.charges.GasteigerMarsiliPartialCharges;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class Electronegativity {
    private GasteigerMarsiliPartialCharges peoe;
    private int maxI;
    private int maxRS;
    private IAtomContainer molSigma;
    private IAtomContainer acOldS;
    private double[] marsiliFactors;
    private final ILoggingTool logger = LoggingToolFactory.createLoggingTool(Electronegativity.class);

    public Electronegativity() {
        this(6, 50);
    }

    public Electronegativity(int maxIterations, int maxResonStruc) {
        this.peoe = new GasteigerMarsiliPartialCharges();
        this.maxI = maxIterations;
        this.maxRS = maxResonStruc;
    }

    public double calculateSigmaElectronegativity(IAtomContainer ac, IAtom atom) {
        return this.calculateSigmaElectronegativity(ac, atom, this.maxI, this.maxRS);
    }

    public double calculateSigmaElectronegativity(IAtomContainer ac, IAtom atom, int maxIterations, int maxResonStruc) {
        this.maxI = maxIterations;
        this.maxRS = maxResonStruc;
        double electronegativity = 0.0;
        try {
            if (!ac.equals(this.acOldS)) {
                this.molSigma = (IAtomContainer)ac.getBuilder().newInstance(IAtomContainer.class, new Object[]{ac});
                this.peoe.setMaxGasteigerIters(this.maxI);
                this.peoe.assignGasteigerMarsiliSigmaPartialCharges(this.molSigma, true);
                this.marsiliFactors = this.peoe.assignGasteigerSigmaMarsiliFactors(this.molSigma);
                this.acOldS = ac;
            }
            int stepSize = this.peoe.getStepSize();
            int atomPosition = ac.indexOf(atom);
            int start = stepSize * atomPosition + atomPosition;
            electronegativity = this.marsiliFactors[start] + this.molSigma.getAtom(atomPosition).getCharge() * this.marsiliFactors[start + 1] + this.marsiliFactors[start + 2] * (this.molSigma.getAtom(atomPosition).getCharge() * this.molSigma.getAtom(atomPosition).getCharge());
            return electronegativity;
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            return electronegativity;
        }
    }

    public void setMaxIterations(int maxIterations) {
        this.maxI = maxIterations;
    }

    public void setMaxResonStruc(int maxResonStruc) {
        this.maxRS = maxResonStruc;
    }

    public int getMaxIterations() {
        return this.maxI;
    }

    public int getMaxResonStruc() {
        return this.maxRS;
    }
}

