/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.integer;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.scheduler.IntEvtScheduler;
import org.chocosolver.solver.variables.view.IntView;
import org.chocosolver.solver.variables.view.ViewDeltaMonitor;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.tools.MathUtils;

public final class IntScaleView<I extends IntVar>
extends IntView<I> {
    public final int cste;

    public IntScaleView(I var, int cste) {
        super("(" + var.getName() + "*" + cste + ")", var);
        assert (cste > 0) : "view cste must be >0";
        this.cste = cste;
    }

    @Override
    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.var.createDelta();
        if (this.var.getDelta() == NoDelta.singleton) {
            return IIntDeltaMonitor.Default.NONE;
        }
        return new ViewDeltaMonitor(this.var.monitorDelta(propagator)){

            @Override
            protected int transform(int value) {
                return IntScaleView.this.cste * value;
            }
        };
    }

    @Override
    protected boolean doInstantiateVar(int value) throws ContradictionException {
        if (value % this.cste != 0) {
            this.model.getSolver().getEventObserver().instantiateTo(this, value, this, this.getLB(), this.getUB());
            this.contradiction(this, "the variable is already instantiated to another value");
        }
        return this.var.instantiateTo(value / this.cste, (ICause)this);
    }

    @Override
    protected boolean doUpdateLowerBoundOfVar(int value) throws ContradictionException {
        return this.var.updateLowerBound(MathUtils.divCeil(value, this.cste), (ICause)this);
    }

    @Override
    protected boolean doUpdateUpperBoundOfVar(int value) throws ContradictionException {
        return this.var.updateUpperBound(MathUtils.divFloor(value, this.cste), (ICause)this);
    }

    @Override
    protected boolean doRemoveValueFromVar(int value) throws ContradictionException {
        return value % this.cste == 0 && this.var.removeValue(value / this.cste, (ICause)this);
    }

    @Override
    protected boolean doRemoveIntervalFromVar(int from, int to) throws ContradictionException {
        return this.var.removeInterval(MathUtils.divCeil(from, this.cste), MathUtils.divFloor(to, this.cste), this);
    }

    @Override
    public boolean contains(int value) {
        return value % this.cste == 0 && this.var.contains(value / this.cste);
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return value % this.cste == 0 && this.var.isInstantiatedTo(value / this.cste);
    }

    @Override
    public int getValue() {
        return this.var.getValue() * this.cste;
    }

    @Override
    public int getLB() {
        return this.var.getLB() * this.cste;
    }

    @Override
    public int getUB() {
        return this.var.getUB() * this.cste;
    }

    @Override
    public int nextValue(int v) {
        int value = this.var.nextValue(MathUtils.divFloor(v, this.cste));
        if (value == Integer.MAX_VALUE) {
            return value;
        }
        return value * this.cste;
    }

    @Override
    public int nextValueOut(int v) {
        if (++v % this.cste == 0 && this.var.contains(v / this.cste)) {
            ++v;
        }
        return v;
    }

    @Override
    public int previousValue(int v) {
        int value = this.var.previousValue(MathUtils.divCeil(v, this.cste));
        if (value == Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return value * this.cste;
    }

    @Override
    public int previousValueOut(int v) {
        if (--v % this.cste == 0 && this.var.contains(v / this.cste)) {
            --v;
        }
        return v;
    }

    protected IntEvtScheduler createScheduler() {
        return new IntEvtScheduler();
    }

    @Override
    public String toString() {
        return "(" + this.var.toString() + " * " + this.cste + ") = [" + this.getLB() + "," + this.getUB() + "]";
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || this._viterator.isNotReusable()) {
            this._viterator = new DisposableValueIterator(){
                DisposableValueIterator vit;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this.vit = IntScaleView.this.var.getValueIterator(true);
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this.vit = IntScaleView.this.var.getValueIterator(false);
                }

                @Override
                public boolean hasNext() {
                    return this.vit.hasNext();
                }

                @Override
                public boolean hasPrevious() {
                    return this.vit.hasPrevious();
                }

                @Override
                public int next() {
                    return this.vit.next() * IntScaleView.this.cste;
                }

                @Override
                public int previous() {
                    return this.vit.previous() * IntScaleView.this.cste;
                }

                @Override
                public void dispose() {
                    super.dispose();
                    this.vit.dispose();
                }
            };
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this.cste == 1) {
            return this.var.getRangeIterator(bottomUp);
        }
        if (this._riterator == null || this._riterator.isNotReusable()) {
            this._riterator = new DisposableRangeIterator(){
                DisposableValueIterator vit;
                int min;
                int max;

                @Override
                public void bottomUpInit() {
                    this.vit = IntScaleView.this.getValueIterator(true);
                    if (this.vit.hasNext()) {
                        this.min = this.vit.next();
                    }
                    this.max = this.min;
                }

                @Override
                public void topDownInit() {
                    this.vit = IntScaleView.this.getValueIterator(false);
                    if (this.vit.hasPrevious()) {
                        this.max = this.vit.previous();
                    }
                    this.min = this.max;
                }

                @Override
                public boolean hasNext() {
                    return this.min != Integer.MAX_VALUE;
                }

                @Override
                public boolean hasPrevious() {
                    return this.max != -2147483647;
                }

                @Override
                public void next() {
                    this.min = this.vit.hasNext() ? (this.max = this.vit.next()) : Integer.MAX_VALUE;
                }

                @Override
                public void previous() {
                    if (this.vit.hasPrevious()) {
                        this.min = this.max = this.vit.previous();
                    } else {
                        this.max = -2147483647;
                    }
                }

                @Override
                public int min() {
                    return this.min;
                }

                @Override
                public int max() {
                    return this.max;
                }
            };
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }

    @Override
    public void justifyEvent(IntEventType mask, int one, int two, int three) {
        switch (mask) {
            case DECUPP: {
                this.model.getSolver().getEventObserver().updateUpperBound(this, one * this.cste, two * this.cste, this);
                break;
            }
            case INCLOW: {
                this.model.getSolver().getEventObserver().updateLowerBound(this, one * this.cste, two * this.cste, this);
                break;
            }
            case REMOVE: {
                this.model.getSolver().getEventObserver().removeValue(this, one * this.cste, this);
                break;
            }
            case INSTANTIATE: {
                this.model.getSolver().getEventObserver().instantiateTo(this, one * this.cste, this, two * this.cste, three * this.cste);
            }
        }
    }
}

