/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.polynomials;

import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.PolynomialException;
import jdplus.toolkit.base.core.math.polynomials.RootsSolver;

public final class RationalFunction {
    private static final RationalFunction ZERO = new RationalFunction();
    private static final RationalFunction ONE = RationalFunction.of(Polynomial.ONE, Polynomial.ONE);
    private volatile double[] coeff;
    private final Polynomial num;
    private final Polynomial denom;
    private static final int ATOM = 32;

    public static RationalFunction of(Polynomial num, Polynomial denom) {
        return new RationalFunction(num, denom, false);
    }

    public static RationalFunction zero() {
        return ZERO;
    }

    public static RationalFunction one() {
        return ONE;
    }

    private RationalFunction() {
        this.num = Polynomial.ZERO;
        this.denom = Polynomial.ONE;
    }

    public RationalFunction(Polynomial pn, Polynomial pd, boolean simplify) {
        if (simplify) {
            Polynomial.SimplifyingTool smp = new Polynomial.SimplifyingTool();
            if (smp.simplify(pn, pd)) {
                this.num = (Polynomial)smp.getLeft();
                this.denom = (Polynomial)smp.getRight();
            } else {
                this.num = pn;
                this.denom = pd;
            }
        } else {
            this.num = pn;
            this.denom = pd;
        }
    }

    public double[] coefficients(int n) {
        this.prepare(n - 1);
        double[] rslt = new double[n];
        int nmin = n > this.coeff.length ? this.coeff.length : n;
        for (int i = 0; i < nmin; ++i) {
            rslt[i] = this.coeff[i];
        }
        return rslt;
    }

    public RationalFunction divide(RationalFunction r2) {
        return new RationalFunction(this.num.times(r2.denom), this.denom.times(r2.num), true);
    }

    public RationalFunction drop(int n) {
        int qc;
        int i;
        int p;
        Polynomial cn = this.num;
        Polynomial cd = this.denom;
        int q = p = cd.degree() + 1;
        if (cn.degree() + 1 - n > q) {
            q = cn.degree() + 1 - n;
        }
        if (q == 0) {
            return new RationalFunction();
        }
        double[] phi = new double[q];
        double[] ntmp = new double[q];
        for (i = 0; i < q; ++i) {
            phi[i] = this.get(i + n);
        }
        ntmp[0] = phi[0] * cd.get(0);
        for (i = 1; i < q; ++i) {
            double s = 0.0;
            int imax = i < q ? i : q - 1;
            for (int j = 0; j <= imax; ++j) {
                int k = i - j;
                if (k >= p) continue;
                s += cd.get(k) * phi[j];
            }
            if (Math.abs(s) < Constants.getEpsilon()) {
                s = 0.0;
            }
            ntmp[i] = s;
        }
        for (qc = q; qc > 0 && ntmp[qc - 1] == 0.0; --qc) {
        }
        if (qc == 0) {
            return new RationalFunction();
        }
        if (qc != q) {
            double[] ntmp2 = new double[qc];
            for (int i2 = 0; i2 < qc; ++i2) {
                ntmp2[i2] = ntmp[i2];
            }
            ntmp = ntmp2;
        }
        return new RationalFunction(Polynomial.ofInternal(ntmp), cd, false);
    }

    public Complex evaluateAt(Complex c) {
        Complex nx = this.num.evaluateAt(c);
        Complex dx = this.denom.evaluateAt(c);
        if (dx.abs() <= Constants.getEpsilon()) {
            throw new PolynomialException("rf_err_pole");
        }
        return nx.div(dx);
    }

    public double evaluateAt(double x) {
        double nx = this.num.evaluateAt(x);
        double dx = this.denom.evaluateAt(x);
        if (Math.abs(dx - 0.0) <= Constants.getEpsilon()) {
            throw new PolynomialException("rf_err_pole");
        }
        return nx / dx;
    }

    public double get(int k) {
        this.prepare(k);
        return k >= this.coeff.length ? 0.0 : this.coeff[k];
    }

    public Polynomial getDenominator() {
        return this.denom;
    }

    public Polynomial getNumerator() {
        return this.num;
    }

    public boolean isFinite() {
        return this.denom.degree() == 0;
    }

    public RationalFunction minus(RationalFunction r2) {
        Polynomial pn = this.num.times(r2.denom).minus(this.denom.times(r2.num));
        Polynomial pd = this.denom.times(r2.denom);
        return new RationalFunction(pn, pd, true);
    }

    public RationalFunction plus(RationalFunction r2) {
        Polynomial pn = this.num.times(r2.denom).plus(this.denom.times(r2.num));
        Polynomial pd = this.denom.times(r2.denom);
        return new RationalFunction(pn, pd, true);
    }

    public Complex[] poles() {
        return this.denom.roots();
    }

    public Complex[] poles(RootsSolver searcher) {
        return this.denom.roots(searcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(int degree) {
        double[] c = this.coeff;
        if (c == null || c.length <= degree) {
            RationalFunction rationalFunction = this;
            synchronized (rationalFunction) {
                int w;
                Polynomial pd = this.denom;
                Polynomial pn = this.num;
                int k0 = 1;
                int p = pd.degree();
                int q = pn.degree();
                double d = pd.get(0);
                if (p == 0) {
                    c = pn.coefficients().toArray();
                    if (d != 1.0) {
                        int i = 0;
                        while (i < c.length) {
                            int n = i++;
                            c[n] = c[n] / d;
                        }
                    }
                    this.coeff = c;
                    return;
                }
                int r = p < q ? q : p;
                degree = degree < r ? r : ((degree - 1) / 32 + 1) * 32;
                if (c == null) {
                    double s;
                    int k;
                    c = new double[degree + 1];
                    c[0] = pn.get(0) / d;
                    for (k = k0; k <= p; ++k) {
                        s = 0.0;
                        for (w = 1; w <= k; ++w) {
                            s += pd.get(w) * c[k - w];
                        }
                        c[k] = k <= q ? (pn.get(k) - s) / d : -s / d;
                    }
                    if (q > p) {
                        for (k = p + 1; k <= q; ++k) {
                            s = 0.0;
                            for (w = 1; w <= p; ++w) {
                                s += pd.get(w) * c[k - w];
                            }
                            c[k] = (pn.get(k) - s) / pd.get(0);
                        }
                    }
                    k0 = r + 1;
                } else {
                    double[] tmp = new double[degree + 1];
                    for (double tmp[u] : c) {
                    }
                    c = tmp;
                }
                for (int k = k0; k <= degree; ++k) {
                    double s = 0.0;
                    for (w = 1; w <= p; ++w) {
                        s += pd.get(w) * c[k - w];
                    }
                    c[k] = -s / d;
                }
                this.coeff = c;
            }
        }
    }

    public Complex[] roots() {
        return this.num.roots();
    }

    public Complex[] roots(RootsSolver searcher) {
        return this.num.roots(searcher);
    }

    public RationalFunction times(RationalFunction r2) {
        return new RationalFunction(this.num.times(r2.num), this.denom.times(r2.denom), true);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        sb.append("[");
        sb.append(this.num.toString());
        sb.append("]/[");
        sb.append(this.denom.toString());
        sb.append("]");
        return sb.toString();
    }
}

