/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.time.LocalDate;
import java.util.List;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.timeseries.Day;
import jdplus.toolkit.base.api.timeseries.DayObs;
import jdplus.toolkit.base.api.timeseries.Days;
import jdplus.toolkit.base.api.timeseries.TimeSeriesData;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import lombok.NonNull;

public class DailyTimeSeries
implements TimeSeriesData<Day, DayObs> {
    private final LocalDate[] domain;
    private final DoubleSeq values;

    public static DailyTimeSeries of(List<DayObs> data) {
        int n = data.size();
        LocalDate[] days = new LocalDate[n];
        double[] v = new double[n];
        int pos = 0;
        for (DayObs obs : data) {
            days[pos] = obs.getDate();
            v[pos++] = obs.getValue();
        }
        return new DailyTimeSeries(days, DoubleSeq.of(v));
    }

    private DailyTimeSeries(LocalDate[] domain, DoubleSeq values) {
        this.domain = domain;
        this.values = values;
    }

    @Override
    public TimeSeriesDomain<Day> getDomain() {
        return Days.of(this.domain);
    }

    @Override
    public DoubleSeq getValues() {
        return this.values;
    }

    @Override
    public DayObs get(int index) throws IndexOutOfBoundsException {
        return DayObs.of(this.domain[index], this.values.get(index));
    }

    @Override
    @NonNull
    public Day getPeriod(int index) throws IndexOutOfBoundsException {
        return Day.of(this.domain[index]);
    }

    @Override
    public int length() {
        return this.domain.length;
    }
}

