### R code from vignette source 'sped.Rnw'

###################################################
### code chunk number 1: options
###################################################
options(keep.source = TRUE, width = 60)


###################################################
### code chunk number 2: library
###################################################
library(sped)


###################################################
### code chunk number 3: ex-one
###################################################
data(alberta)
head(alberta)
descent(1260, alberta, c("52"=1))


###################################################
### code chunk number 4: ex-two
###################################################
descent(c(1085, 1094, 1180, 1260), alberta, c("52"=1))


###################################################
### code chunk number 5: ex-three
###################################################
vescent <- Vectorize(descent, vectorize.args = "individuals")
b <- c(1085, 1094, 1180, 1260)
names(b) <- b
vescent(b, alberta, c("52"=1))


###################################################
### code chunk number 6: ex-gamma
###################################################
data(thompson)
gammas(c("U", "V", "Q", "R", "W"), thompson)


###################################################
### code chunk number 7: ex-beta
###################################################
foo <- betas(c("U", "V", "Q", "R", "W"), thompson)
foo


###################################################
### code chunk number 8: ex-beta-too
###################################################
foo["B", "Q"]


###################################################
### code chunk number 9: ex-alpha
###################################################
foo <- alphas(c("U", "V", "Q", "R", "W"), thompson)
foo


###################################################
### code chunk number 10: ex-inbreeding
###################################################
colSums(foo)


###################################################
### code chunk number 11: ex-inbreeding-too
###################################################
inbreeding(c("U", "V", "Q", "R", "W"), thompson)


###################################################
### code chunk number 12: ex-kinship
###################################################
foo <- kinship(c("U", "V", "Q", "R", "W"), thompson)
foo


###################################################
### code chunk number 13: ex-kinship-too
###################################################
foo["Q", "R"]


###################################################
### code chunk number 14: ex-kinship-too-too
###################################################
foo["Q", "Q"]


###################################################
### code chunk number 15: ex-inbreeding-queue
###################################################
inbreeding("Q", thompson)


###################################################
### code chunk number 16: numerator-relationship-matrix
###################################################
foo <- 2 * kinship(unique(thompson), thompson)


