/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.evomodel.substmodel.LogAdditiveCtmcRateProvider;
import dr.inference.loggers.LogColumn;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.StateSet;
import dr.inference.model.Variable;
import dr.math.matrixAlgebra.WrappedVector;
import dr.xml.Reportable;
import java.util.Arrays;
import java.util.List;

public class StronglyLumpableCtmcRates
extends AbstractModel
implements LogAdditiveCtmcRateProvider,
Reportable {
    private final SuperInfo[] map;
    private final List<Lump> lumps;
    private final Parameter acrossRates;
    private final int stateCount;
    private final int dim;
    private double[] rates;
    private double[] storedRates;
    private boolean ratesKnown = false;
    private static final boolean CACHE = false;

    public StronglyLumpableCtmcRates(String string, List<Lump> list, Parameter parameter, DataType dataType) {
        super(string);
        this.lumps = list;
        this.acrossRates = parameter;
        this.stateCount = dataType.getStateCount();
        this.dim = this.stateCount * (this.stateCount - 1);
        this.rates = new double[this.dim];
        this.map = this.buildSuperMap();
        for (Lump lump : list) {
            if (lump.rates != null) {
                this.addVariable(lump.rates);
            }
            if (lump.proportions == null) continue;
            for (Proportion proportion : lump.proportions) {
                this.addVariable(proportion.parameter);
            }
        }
        this.addVariable(parameter);
        this.computeRates(this.rates);
    }

    private double getRate(int n) {
        double d;
        SuperInfo superInfo = this.map[n];
        if (superInfo.within) {
            d = superInfo.withinRateParameter.getParameterValue(superInfo.withinRateIndex);
        } else {
            double d2 = superInfo.acrossProportionParameter.getParameterValue(superInfo.acrossProportionIndex);
            double d3 = this.acrossRates.getParameterValue(superInfo.acrossRateIndex);
            d = superInfo.acrossProportionParameter.getParameterValue(superInfo.acrossProportionIndex) * this.acrossRates.getParameterValue(superInfo.acrossRateIndex);
        }
        return d;
    }

    private void computeRates(double[] dArray) {
        for (int i = 0; i < this.dim; ++i) {
            dArray[i] = this.getRate(i);
        }
    }

    private SuperInfo[] buildSuperMap() {
        LumpIndex lumpIndex;
        int n;
        LumpIndex lumpIndex2;
        int n2;
        SuperInfo[] superInfoArray = new SuperInfo[this.dim];
        int n3 = 0;
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            lumpIndex2 = this.getLumpIndex(n2);
            assert (lumpIndex2 != null);
            for (n = n2 + 1; n < this.stateCount; ++n) {
                lumpIndex = this.getLumpIndex(n);
                assert (lumpIndex != null);
                superInfoArray[n3++] = new SuperInfo(lumpIndex2, lumpIndex);
            }
        }
        for (n2 = 0; n2 < this.stateCount; ++n2) {
            lumpIndex2 = this.getLumpIndex(n2);
            assert (lumpIndex2 != null);
            for (n = n2 + 1; n < this.stateCount; ++n) {
                lumpIndex = this.getLumpIndex(n);
                assert (lumpIndex != null);
                superInfoArray[n3++] = new SuperInfo(lumpIndex, lumpIndex2);
            }
        }
        return superInfoArray;
    }

    private static int[] buildMap(int n) {
        int n2;
        int n3;
        int[] nArray = new int[n * n];
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = n3 + 1; n2 < n; ++n2) {
                nArray[n3 * n + n2] = n4++;
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = n3 + 1; n2 < n; ++n2) {
                nArray[n2 * n + n3] = n4++;
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            nArray[n3 * n + n3] = -1;
        }
        return nArray;
    }

    private LumpIndex getLumpIndex(int n) {
        for (int i = 0; i < this.lumps.size(); ++i) {
            Lump lump = this.lumps.get(i);
            for (int j = 0; j < lump.count; ++j) {
                if (n != lump.states[j]) continue;
                for (int k = 0; k < lump.count; ++k) {
                    if (n != lump.originalStates[k]) continue;
                    return new LumpIndex(i, j, k, lump.count);
                }
            }
        }
        return null;
    }

    @Override
    public double[] getXBeta() {
        return null;
    }

    @Override
    public LogColumn[] getColumns() {
        return null;
    }

    @Override
    public double[] getRates() {
        this.computeRates(this.rates);
        this.ratesKnown = true;
        return this.rates;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        throw new IllegalArgumentException("No sub-models");
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.ratesKnown = false;
        this.fireModelChanged(variable, n);
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public String getReport() {
        double[] dArray = this.getRates();
        return new WrappedVector.Raw(dArray).toString();
    }

    private class SuperInfo {
        final LumpIndex i;
        final LumpIndex j;
        final boolean within;
        final int withinRateIndex;
        final int acrossRateIndex;
        final int acrossProportionIndex;
        final Parameter withinRateParameter;
        final Parameter acrossProportionParameter;

        SuperInfo(LumpIndex lumpIndex, LumpIndex lumpIndex2) {
            this.i = lumpIndex;
            this.j = lumpIndex2;
            this.within = lumpIndex.lump == lumpIndex2.lump;
            Lump lump = (Lump)StronglyLumpableCtmcRates.this.lumps.get(lumpIndex.lump);
            this.withinRateIndex = this.within ? lump.map[lumpIndex.index * lumpIndex.count + lumpIndex2.index] : -1;
            int[] nArray = StronglyLumpableCtmcRates.buildMap(StronglyLumpableCtmcRates.this.lumps.size());
            this.acrossRateIndex = !this.within ? nArray[lumpIndex.lump * StronglyLumpableCtmcRates.this.lumps.size() + lumpIndex2.lump] : -1;
            int n = lumpIndex.lump < lumpIndex2.lump ? lumpIndex2.lump : lumpIndex2.lump + 1;
            this.acrossProportionIndex = !this.within ? lumpIndex2.index : -1;
            this.withinRateParameter = this.within ? lump.rates : null;
            this.acrossProportionParameter = !this.within ? lump.proportions.get((int)(lumpIndex.originalIndex * (((StronglyLumpableCtmcRates)StronglyLumpableCtmcRates.this).lumps.size() - 1) + n - 1)).parameter : null;
        }
    }

    public static class Lump {
        final String id;
        final int[] states;
        final Parameter rates;
        final List<Proportion> proportions;
        final int count;
        final int[] map;
        final int[] originalStates;

        public Lump(String string, List<Integer> list, Parameter parameter, List<Proportion> list2) {
            this(string, list.stream().mapToInt(n -> n).toArray(), parameter, list2);
        }

        public Lump(String string, int[] nArray, Parameter parameter, List<Proportion> list) {
            this.id = string;
            this.states = nArray;
            this.rates = parameter;
            this.proportions = list;
            this.count = nArray.length;
            this.originalStates = (int[])nArray.clone();
            Arrays.sort(nArray);
            this.map = StronglyLumpableCtmcRates.buildMap(this.count);
        }
    }

    public static class Proportion {
        final int source;
        final StateSet destination;
        final Parameter parameter;

        public Proportion(int n, StateSet stateSet, Parameter parameter) {
            this.source = n;
            this.destination = stateSet;
            this.parameter = parameter;
        }
    }

    private static class LumpIndex {
        final int lump;
        final int index;
        final int count;
        final int originalIndex;

        LumpIndex(int n, int n2, int n3, int n4) {
            this.lump = n;
            this.index = n2;
            this.count = n4;
            this.originalIndex = n3;
        }
    }
}

