/*
 * Decompiled with CFR 0.152.
 */
package dr.evoxml;

import dr.evolution.datatype.Microsatellite;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AndRule;
import dr.xml.AttributeRule;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;

public class MicrosatelliteParser
extends AbstractXMLObjectParser {
    public static final String MICROSAT = "microsatellite";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String UNIT_LENGTH = "unitLength";

    @Override
    public String getParserName() {
        return MICROSAT;
    }

    @Override
    public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
        int n = xMLObject.getIntegerAttribute(MIN);
        int n2 = xMLObject.getIntegerAttribute(MAX);
        int n3 = xMLObject.hasAttribute(UNIT_LENGTH) ? xMLObject.getIntegerAttribute(UNIT_LENGTH) : 1;
        String string = xMLObject.getId();
        return new Microsatellite(string, n, n2, n3);
    }

    @Override
    public String getParserDescription() {
        return "This element represents a microsatellite data type.";
    }

    @Override
    public String getExample() {
        return "<microsatellite min=\"0\" max=\"20\" unitLength=\"2\"/>";
    }

    @Override
    public XMLSyntaxRule[] getSyntaxRules() {
        return new XMLSyntaxRule[]{new AndRule(new XMLSyntaxRule[]{AttributeRule.newStringRule("id"), AttributeRule.newIntegerRule(MIN), AttributeRule.newIntegerRule(MAX), AttributeRule.newIntegerRule(UNIT_LENGTH, true)})};
    }

    @Override
    public Class getReturnType() {
        return Microsatellite.class;
    }
}

