/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.GeneticFuzzyAprioriDC;

import java.util.Arrays;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.FuzzyRuleLearning.GeneticFuzzyAprioriDC.MembershipFunction;

public class Gene {
    private MembershipFunction[] membershipFunctions;

    public Gene(MembershipFunction[] membership_functions) {
        this.setMembershipFunctions(membership_functions);
    }

    private void setMembershipFunctions(MembershipFunction[] membership_functions) {
        this.membershipFunctions = new MembershipFunction[membership_functions.length];
        for (int i = 0; i < this.membershipFunctions.length; ++i) {
            this.membershipFunctions[i] = membership_functions[i].clone();
        }
    }

    public MembershipFunction[] getMembershipFunctions() {
        return this.membershipFunctions;
    }

    public double calculateOverlapFactor() {
        double overlap_factor = 0.0;
        for (int i = 0; i < this.membershipFunctions.length; ++i) {
            for (int j = i + 1; j < this.membershipFunctions.length; ++j) {
                double min_w = Math.min(this.membershipFunctions[i].getW(), this.membershipFunctions[j].getW());
                overlap_factor += Math.max(this.membershipFunctions[i].calculateOverlapLength(this.membershipFunctions[j]) / min_w, 1.0) - 1.0;
            }
        }
        return overlap_factor;
    }

    public double calculateCoverageFactor(double min_attr, double max_attr) {
        double x3;
        double x0;
        double min_x0 = this.membershipFunctions[0].getC() - this.membershipFunctions[0].getW();
        double max_x3 = this.membershipFunctions[0].getC() + this.membershipFunctions[0].getW();
        int id_min_region = 0;
        for (int id_region = 1; id_region < this.membershipFunctions.length; ++id_region) {
            x0 = this.membershipFunctions[id_region].getC() - this.membershipFunctions[id_region].getW();
            x3 = this.membershipFunctions[id_region].getC() + this.membershipFunctions[id_region].getW();
            if (x0 < min_x0) {
                min_x0 = x0;
                id_min_region = id_region;
            }
            if (!(x3 > max_x3)) continue;
            max_x3 = x3;
        }
        double range = 0.0;
        if (min_x0 < min_attr) {
            range -= min_attr - min_x0;
        }
        if (max_x3 > max_attr) {
            range -= max_x3 - max_attr;
        }
        while (id_min_region < this.membershipFunctions.length) {
            min_x0 = this.membershipFunctions[id_min_region].getC() - this.membershipFunctions[id_min_region].getW();
            max_x3 = this.membershipFunctions[id_min_region].getC() + this.membershipFunctions[id_min_region].getW();
            boolean change = false;
            for (int k = 0; k < this.membershipFunctions.length; ++k) {
                x0 = this.membershipFunctions[k].getC() - this.membershipFunctions[k].getW();
                x3 = this.membershipFunctions[k].getC() + this.membershipFunctions[k].getW();
                if (!(min_x0 < x0) || !(x0 < max_x3) || !(x3 > max_x3)) continue;
                max_x3 = x0;
                id_min_region = k;
                change = true;
            }
            range += max_x3 - min_x0;
            if (change) continue;
            boolean stop = false;
            ++id_min_region;
            while (!stop && id_min_region < this.membershipFunctions.length) {
                x0 = this.membershipFunctions[id_min_region].getC() - this.membershipFunctions[id_min_region].getW();
                if (x0 < max_x3) {
                    ++id_min_region;
                    continue;
                }
                stop = true;
            }
        }
        return 1.0 / (range / (max_attr - min_attr));
    }

    public void sortMembershipFunctions() {
        Arrays.sort(this.membershipFunctions);
    }

    public Gene clone() {
        Gene gene = new Gene(this.membershipFunctions);
        return gene;
    }

    public String toString() {
        int i;
        String str = "[";
        for (i = 0; i < this.membershipFunctions.length - 1; ++i) {
            str = str + this.membershipFunctions[i] + "; ";
        }
        str = str + this.membershipFunctions[i] + "]";
        return str;
    }
}

