/*
 * Decompiled with CFR 0.152.
 */
package org.act.rscat.sim;

import java.io.IOException;
import java.util.List;
import org.act.rscat.cat.CatConfig;
import org.act.rscat.sim.SimOutput;
import org.act.rscat.sol.InfeasibleTestConfigException;
import org.act.rscat.testdef.TestConfig;
import org.act.rscat.util.ProbDistribution;

public abstract class AbstractCatSimulation {
    private String simName;
    private int examineeNum;
    private ProbDistribution thetaDistribution;
    private TestConfig testConfig;
    private CatConfig catConfig;
    private boolean isGenSimResult;

    protected AbstractCatSimulation(String simName, int examineeNum, ProbDistribution thetaDistribution, TestConfig testConfig, CatConfig catConfig, boolean isGenSimResult) {
        this.simName = simName;
        this.examineeNum = examineeNum;
        this.thetaDistribution = thetaDistribution;
        this.testConfig = testConfig;
        this.catConfig = catConfig;
        this.isGenSimResult = isGenSimResult;
    }

    public abstract List<SimOutput> runSim() throws IOException, InfeasibleTestConfigException;

    protected double[] genTrueThetas(double min, double max) {
        return this.thetaDistribution.sample(this.examineeNum, min, max);
    }

    protected double[] genTrueThetas() {
        return this.thetaDistribution.sample(this.examineeNum);
    }

    public String getSimName() {
        return this.simName;
    }

    public int getExamineeNum() {
        return this.examineeNum;
    }

    public ProbDistribution getThetaDistribution() {
        return this.thetaDistribution;
    }

    public CatConfig getCatConfig() {
        return this.catConfig;
    }

    public TestConfig getTestConfig() {
        return this.testConfig;
    }

    public boolean isGenSimResult() {
        return this.isGenSimResult;
    }
}

