/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.tests;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import org.af.commons.images.GraphDrawHelper;

class PaintPanel3Points
extends JPanel
implements MouseListener {
    double a1 = 100.0;
    double a2 = 100.0;
    double b1 = 120.0;
    double b2 = 80.0;
    double c1 = 180.0;
    double c2 = 130.0;

    public PaintPanel3Points(double a1, double a2, double b1, double b2, double c1, double c2) {
        this.a1 = a1;
        this.a2 = a2;
        this.b1 = b1;
        this.b2 = b2;
        this.c1 = c1;
        this.c2 = c2;
        this.setSize(200, 200);
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.BLACK);
        g.drawOval((int)this.a1 - 1, (int)this.a2 - 1, 2, 2);
        g.drawString("A", (int)this.a1, (int)this.a2);
        g.drawOval((int)this.b1 - 1, (int)this.b2 - 1, 2, 2);
        g.drawString("B", (int)this.b1, (int)this.b2);
        g.drawOval((int)this.c1 - 1, (int)this.c2 - 1, 2, 2);
        g.drawString("C", (int)this.c1, (int)this.c2);
        GraphDrawHelper.drawEdge((Graphics)g, (double)this.a1, (double)this.a2, (double)this.b1, (double)this.b2, (double)this.c1, (double)this.c2, (int)8, (int)45, (boolean)true);
    }

    protected void test1(Graphics g) {
        double a = 100.0;
        double b = 100.0;
        double c = 200.0;
        double d = 200.0;
        double alpha = 1.0471975511965976;
        double s = Math.sqrt((c - a) * (c - a) + (d - b) * (d - b));
        double r = s / (2.0 * Math.sin(alpha));
        System.out.println("Radius is " + r + ".");
        double p1 = (a + c) / 2.0;
        double p2 = (b + d) / 2.0;
        double h = s / 2.0 * Math.cos(alpha) / Math.sin(alpha);
        double z1 = -1.0;
        double z2 = -(a - c) * z1 / (b - d);
        System.out.println("Z is (" + z1 + "," + z2 + ").");
        double zb = Math.sqrt(z1 * z1 + z2 * z2);
        double m1 = p1 + h * (z1 /= zb);
        double m2 = p2 + h * (z2 /= zb);
        g.drawOval((int)a - 1, (int)b - 1, 2, 2);
        g.drawString("1", (int)a, (int)b);
        g.drawOval((int)c - 1, (int)d - 1, 2, 2);
        g.drawString("2", (int)c, (int)d);
        g.drawOval((int)m1 - 1, (int)m2 - 1, 2, 2);
        g.drawString("M", (int)m1, (int)m2);
        double phi1 = Math.atan((-b + m2) / (a - m1)) * 360.0 / (Math.PI * 2) + (double)(a - m1 < 0.0 ? 180 : 0);
        double phi2 = Math.atan((-d + m2) / (c - m1)) * 360.0 / (Math.PI * 2) + (double)(c - m1 < 0.0 ? 180 : 0);
        System.out.println("phi is (" + phi1 + "," + phi2 + ").");
        g.drawArc((int)(m1 - r), (int)(m2 - r), (int)(2.0 * r), (int)(2.0 * r), (int)phi1, (int)(phi2 - phi1));
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.b1 = e.getX();
        this.b2 = e.getY();
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

