# liftr 0.9.2 (2019-06-18)

## Bug Fixes

- Switched to absolute URLs for the contributing guidelines and contributor code of conduct in the readme.

# liftr 0.9.1 (2019-06-18)

## Bug Fixes

- Fixed the issue of parsing Bioconductor package names ([#45](https://github.com/nanxstats/liftr/issues/45)) for R >= 3.5 and the introduction of BiocManager. We thank Tiago Lubiana for contributing the patch.

# liftr 0.9 (2018-05-13)

## Improvements

- Added a new argument `dry_run` in `render_docker()` for debugging: when set to `TRUE`, it will only return the Docker commands and not actually run them.
- New URL for the documentation website: https://nanx.me/liftr/.

# liftr 0.8 (2017-12-12)

## New Features

- Added a new argument `prune` in `render_docker()` to automatically clean up dangling containers and images in case the image build or compilation was not successful ([#27](https://github.com/nanxstats/liftr/issues/27)). We thank Nicolas Roelandt for suggesting this feature ([#25](https://github.com/nanxstats/liftr/issues/25)).
- Added functions `prune_container_auto()`, `prune_image_auto()`, and `prune_all_auto()` for automatic pruning of dangling containers or images without particular names specified.
- Added function `install_docker()` for guiding the installation of Docker.
- Added function `check_docker_install()`for checking if Docker is properly installed and discoverable.
- Added function `check_docker_running()` for checking if Docker daemon is running.

## Improvements

- The argument `purge_info` was renamed to `prune_info` in `render_docker()`.
- Previous functions for cleaning up specific Docker containers and images `purge_container()` and `purge_image()` are now renamed to `prune_container()` and `prune_image()`.
- RStudio addin: the old addin for removing Docker images was refactored into two new addins: one for removing dangling containers and images, one for removing the successfully built image that corresponds to the current document.
- Added two new vignettes. Check out `vignette("liftr-addins")` and `vignette("liftr-tidyverse")`.

# liftr 0.7 (2017-09-29)

## Improvements

- Use system font stack instead of Google Fonts in vignettes to avoid pandoc SSL issue.

# liftr 0.6 (2017-07-23)

## New Features

- Supports parsing the liftr metadata from a standalone YAML congfiguration file. This feature makes it possible to run liftr without editing the original R Markdown file [[#22](https://github.com/nanxstats/liftr/issues/22)].

# liftr 0.5 (2017-04-11)

## New Features

- Added RStudio addins as shortcuts to containerize and render R Markdown documents.
- Added new argument `cache` in `render_docker()` to improve rendering speed significantly by caching Docker image layers [[#18](https://github.com/nanxstats/liftr/issues/18)].
- Added new argument `purge_info` to `render_docker()`. This argument controls whether to output the Docker image and container name into an YAML file for purging purposes later.
- Separate the creation and removal of Docker containers and images: removed the old argument `reset` in `render_docker()`; added `purge_container()` and `purge_image()` for cleaning up.
- The `ghpkg` field is now deprecated. The new `remotes` field supports [devtools remote package name format](https://github.com/hadley/devtools/blob/master/vignettes/dependencies.Rmd). Now packages can be installed from GitHub, Bitbucket, Git/SVN servers, URLs, etc.
- Added new metadata field `include` for including any custom Dockerfile snippets into the final Dockerfile. This also fixes [#21](https://github.com/nanxstats/liftr/issues/21).

## Improvements

- Renamed `drender()` to `render_docker()`. `drender()` is now deprecated.
- Better naming scheme for `liftr` metadata fields.
- Tidy up the output Dockerfile by `lift()`.
- Added two new examples in `inst/examples/`: explore tidyverse and Bioconductor RNA-Seq workflow.
- New documentation website generated by pkgdown, with a full set of function documentation and vignettes available.
- Added Appveyor support for continuous integration under Windows.
- Removed Rabix support temporarily to embrace its new version in the future.
- Added a new demo video.

## Bug Fixes

- Removed `-t` and `-i` from `docker run` to fix [#17](https://github.com/nanxstats/liftr/issues/17).

# liftr 0.4 (2016-08-05)

## Improvements

- Maintainer email updates.

# liftr 0.3 (2015-10-10)

## New Features

- Support specifying CRAN package version precisely.

## Improvements

- Modified examples in documentation to comply with the lastest CRAN Repository Policy.
- Installing packages with https.

# liftr 0.2 (2015-07-30)

## Bug Fixes

- [Correctly rendered](https://github.com/rstudio/rmarkdown/issues/470) the vignette with Pandoc 1.15.0.6.

## New Features

- Added new R Markdown header option `pandoc` to control Pandoc installation. Automatically set this to `false` for `rocker/rstudio` and `bioconductor/...` images. This solves [#12](https://github.com/nanxstats/liftr/issues/12).

# liftr 0.1 (2015-07-10)

## New Features

- Initial version of liftr. This version implemented two functions `lift()` and `drender()`. They provide basic support for dockerizing R Markdown documents, with support for running Rabix workflows/tools before rendering R Markdown documents in Docker containers.
