/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling.cumulative;

import choco.cp.solver.constraints.global.scheduling.AbstractResourceSConstraint;
import choco.kernel.common.util.bitmask.StringMask;
import choco.kernel.common.util.tools.ArrayUtils;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateBool;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.global.scheduling.ICumulativeResource;
import choco.kernel.solver.variables.integer.IntDomainVar;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.List;

public abstract class AbstractCumulativeSConstraint
extends AbstractResourceSConstraint
implements ICumulativeResource<TaskVar> {
    public static final StringMask TASK_INTERVAL = new StringMask("cp:cumulative:task_intervals", 1L);
    public static final StringMask TASK_INTERVAL_SLOW = new StringMask("cp:cumulative:slow_task_intervals", 4L);
    public static final StringMask VILIM_CEF_ALGO = new StringMask("cp:cumulative:edge_finding:vilim", 8L);
    public static final StringMask VHM_CEF_ALGO_N2K = new StringMask("cp:cumulative:edge_finding", 16L);
    private final IStateBool fixedHeights;
    private final IStateBool positiveHeights;
    private final IStateBool regularWithNegativeHeight;
    protected final int indexConsumption;
    protected final int indexCapacity;

    public AbstractCumulativeSConstraint(Solver solver, String name, TaskVar[] taskvars, int nbOptionalTasks, IntDomainVar consumption, IntDomainVar capacity, IntDomainVar uppBound, IntDomainVar ... otherVars) {
        super(solver, name, taskvars, nbOptionalTasks, true, false, ArrayUtils.append(otherVars, {consumption, capacity, uppBound}));
        this.indexConsumption = this.taskIntVarOffset + otherVars.length;
        this.indexCapacity = this.indexConsumption + 1;
        IEnvironment env = solver.getEnvironment();
        this.fixedHeights = env.makeBool(false);
        this.positiveHeights = env.makeBool(false);
        this.regularWithNegativeHeight = env.makeBool(false);
    }

    @Override
    public void readOptions(List<String> options) {
        this.flags.read(options, TASK_INTERVAL, TASK_INTERVAL_SLOW, VHM_CEF_ALGO_N2K, VILIM_CEF_ALGO);
    }

    @Override
    public boolean isTaskConsistencyEnforced() {
        return true;
    }

    public final boolean updateMinCapacity(int val) throws ContradictionException {
        return ((IntDomainVar[])this.vars)[this.indexCapacity].updateInf(val, this, false);
    }

    public final boolean updateMaxCapacity(int val) throws ContradictionException {
        return ((IntDomainVar[])this.vars)[this.indexCapacity].updateSup(val, this, false);
    }

    public final boolean updateMinConsumption(int val) throws ContradictionException {
        return ((IntDomainVar[])this.vars)[this.indexConsumption].updateInf(val, this, false);
    }

    public final boolean updateMaxConsumption(int val) throws ContradictionException {
        return ((IntDomainVar[])this.vars)[this.indexConsumption].updateSup(val, this, false);
    }

    @Override
    public final IntDomainVar getCapacity() {
        return (IntDomainVar)this.getVar(this.indexCapacity);
    }

    @Override
    public final int getMaxCapacity() {
        return this.getCapacity().getSup();
    }

    @Override
    public final int getMinCapacity() {
        return this.getCapacity().getInf();
    }

    @Override
    public final IntDomainVar getConsumption() {
        return ((IntDomainVar[])this.vars)[this.indexConsumption];
    }

    @Override
    public final int getMaxConsumption() {
        return this.getConsumption().getSup();
    }

    @Override
    public final int getMinConsumption() {
        return this.getConsumption().getInf();
    }

    @Override
    public final IntDomainVar getHeight(int idx) {
        return (IntDomainVar)this.getVar(this.getHeightIndex(idx));
    }

    @Override
    public final boolean isInstantiatedHeights() {
        if (!this.fixedHeights.get()) {
            for (int i = 0; i < this.getNbTasks(); ++i) {
                IRTask rtask = this.getRTask(i);
                if (rtask.isEliminated() || rtask.getHeight().isInstantiated()) continue;
                return false;
            }
            this.fixedHeights.set(true);
        }
        return true;
    }

    @Override
    public final boolean hasOnlyPosisiveHeights() {
        if (!this.positiveHeights.get()) {
            if (this.regularWithNegativeHeight.get()) {
                return false;
            }
            for (int i = 0; i < this.getNbTasks(); ++i) {
                IRTask rtask = this.getRTask(i);
                if (rtask.isEliminated() || rtask.getMinHeight() >= 0) continue;
                if (rtask.isRegular()) {
                    this.regularWithNegativeHeight.set(true);
                }
                return false;
            }
            this.positiveHeights.set(true);
        }
        return true;
    }

    @Override
    public final boolean isSatisfied(int[] tuple) {
        return this.isCumulativeSatisfied(tuple, tuple[this.indexConsumption], tuple[this.indexCapacity]);
    }

    @Override
    public Boolean isEntailed() {
        throw new UnsupportedOperationException("isEntailed not yet implemented on choco.global.scheduling.Cumulative");
    }
}

